/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.module.config.impl;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Searcher;
import pl.edu.icm.yadda.service.search.SearchException;
import pl.edu.icm.yadda.service.search.errors.SearchMultiExceptionFactory;
import pl.edu.icm.yadda.service.search.module.config.IndexMetadata;
import pl.edu.icm.yadda.service.search.module.config.LuceneSearcherData;

public class LuceneSearcherDataImpl
implements LuceneSearcherData {
    private static final Log log = LogFactory.getLog(LuceneSearcherDataImpl.class);
    private String indexName;
    private IndexMetadata indexMetadata;
    private Searcher searcher;
    private IndexReader indexReader;
    private long indexVersion;
    private int documentsNumber;
    private int maxDoc;
    protected int refCount = 0;
    private Status status = Status.OPENED;
    protected boolean closeSearcher = true;
    protected boolean closeReader = true;

    public LuceneSearcherDataImpl(Searcher searcher, IndexReader indexReader, IndexMetadata indexMetadata, long l, int n) throws IOException {
        this.searcher = searcher;
        this.indexReader = indexReader;
        this.indexMetadata = indexMetadata;
        this.indexVersion = l;
        this.maxDoc = searcher.maxDoc();
        this.documentsNumber = n;
    }

    public Searcher getSearcher() {
        return this.searcher;
    }

    public IndexReader getIndexReader() {
        return this.indexReader;
    }

    public long getIndexVersion() {
        return this.indexVersion;
    }

    public int getDocumentsNumber() {
        return this.documentsNumber;
    }

    public int getMaxDoc() {
        return this.maxDoc;
    }

    protected void setIndexMetadata(IndexMetadata indexMetadata) {
        this.indexMetadata = indexMetadata;
    }

    public IndexMetadata getIndexMetadata() {
        return this.indexMetadata;
    }

    public void setIndexName(String string) {
        this.indexName = string;
    }

    public synchronized void close() throws SearchException {
        if (this.status == Status.OPENED) {
            if (this.refCount == 0) {
                this.doClose();
            } else {
                this.status = Status.CLOSING;
            }
        }
    }

    public synchronized void release() throws SearchException {
        --this.refCount;
        if (this.refCount == 0 && this.status == Status.CLOSING) {
            this.doClose();
        }
    }

    public synchronized void acquire() throws SearchException {
        if (this.status != Status.OPENED) {
            throw new SearchException("LuceneSearcherData is not opened");
        }
        ++this.refCount;
    }

    protected void doClose() throws SearchException {
        this.status = Status.CLOSED;
        ArrayList<Exception> arrayList = null;
        if (this.closeSearcher) {
            try {
                this.searcher.close();
                log.info((Object)("Physical Lucene searcher has been closed (index:" + this.indexName + " version:" + this.indexVersion + ")"));
            }
            catch (Exception exception) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Exception>();
                }
                arrayList.add(exception);
            }
        }
        if (this.closeReader) {
            try {
                this.indexReader.close();
                log.info((Object)("Physical Lucene reader has been closed (index:" + this.indexName + " version:" + this.indexVersion + ")"));
            }
            catch (Exception exception) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(exception);
            }
        }
        if (arrayList != null) {
            throw SearchMultiExceptionFactory.createException("Closing of Lucene searcher data for index '" + this.indexName + "' failed", arrayList);
        }
    }

    public String getIndexName() {
        return this.indexName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Status {
        OPENED,
        CLOSING,
        CLOSED;

    }
}

