/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.module.config.impl;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import pl.edu.icm.yadda.service.search.indexing.IndexUtils;

public class PerFieldWithVariantsAnalyzerWrapper
extends Analyzer {
    private Analyzer defaultAnalyzer;
    private Map<String, Analyzer> analyzerMap = new HashMap<String, Analyzer>();
    private Map<String, Integer> spanMap = new HashMap<String, Integer>();

    public PerFieldWithVariantsAnalyzerWrapper(Analyzer analyzer) {
        if (analyzer == null) {
            throw new IllegalArgumentException("Default analyzer for " + PerFieldWithVariantsAnalyzerWrapper.class.getName() + " can not be null");
        }
        this.defaultAnalyzer = analyzer;
    }

    public void addAnalyzer(String string, Analyzer analyzer) {
        this.analyzerMap.put(string, analyzer);
    }

    public void setSpan(String string, int n) {
        if (n < -1) {
            throw new IllegalArgumentException("Span must be greater or equal to -1");
        }
        if (n >= 0) {
            this.spanMap.put(string, n);
        }
    }

    public int getPositionIncrementGap(String string) {
        Integer n = this.spanMap.get(string);
        return n == null ? 1 : n + 1;
    }

    public TokenStream tokenStream(String string, Reader reader) {
        return this.getAnalyzer(string).tokenStream(string, reader);
    }

    public String toString() {
        return "PerFieldWithVariantsAnalyzerWrapper(" + this.analyzerMap + ", default=" + this.defaultAnalyzer + ")";
    }

    protected final Analyzer getAnalyzer(String string) {
        Analyzer analyzer = this.analyzerMap.get(string);
        if (analyzer == null) {
            String string2 = IndexUtils.getFieldNameWithoutVariant((String)string);
            if (string2 != null) {
                analyzer = this.analyzerMap.get(string);
            }
            if (analyzer == null) {
                analyzer = this.defaultAnalyzer;
            }
        }
        return analyzer;
    }
}

