/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.module.config.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import pl.edu.icm.yadda.common.utils.FileUtils;
import pl.edu.icm.yadda.service.search.SearchException;
import pl.edu.icm.yadda.service.search.errors.IndexAlreadyOpenedException;
import pl.edu.icm.yadda.service.search.errors.IndexNotOpenedException;
import pl.edu.icm.yadda.service.search.errors.ObjectDestroyedException;
import pl.edu.icm.yadda.service.search.errors.SearchConfigException;
import pl.edu.icm.yadda.service.search.indexing.IndexingException;
import pl.edu.icm.yadda.service.search.indexing.impl.document.LuceneDocument;
import pl.edu.icm.yadda.service.search.module.config.AnalyzerFactory;
import pl.edu.icm.yadda.service.search.module.config.LuceneSearcherData;
import pl.edu.icm.yadda.service.search.module.config.PhysicalLuceneIndex;
import pl.edu.icm.yadda.service.search.module.config.impl.LuceneSearcherDataImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhysicalLuceneIndexImpl
implements PhysicalLuceneIndex {
    private static final Log log = LogFactory.getLog(PhysicalLuceneIndexImpl.class);
    private AnalyzerFactory analyzerFactory;
    private IndexWriter writer;
    private File indexDir;
    private boolean opened = false;
    private boolean destroyed = false;
    private double ramBufferSizeMB = 32.0;
    private int maxMergeDocs = Integer.MAX_VALUE;
    private int mergeFactor = 10;
    private int maxFieldLength = Integer.MAX_VALUE;

    public PhysicalLuceneIndexImpl(String string, AnalyzerFactory analyzerFactory) throws SearchConfigException {
        this.setAnalyzerFactory(analyzerFactory);
        this.indexDir = new File(string);
        if (!this.indexDir.exists()) {
            this.indexDir.mkdirs();
        }
        if (!IndexReader.indexExists((File)this.indexDir)) {
            try {
                this.createEmptyIndex();
                log.info((Object)("Lucene index at [" + this.indexDir.getAbsolutePath() + "] did not exist and so empty index has been created."));
            }
            catch (IndexingException indexingException) {
                throw new SearchConfigException("Couldn't create empty index at [" + this.indexDir.getAbsolutePath() + "]");
            }
        }
        log.info((Object)("Physical lucene index created for path [" + string + "] (hashcode: " + this.hashCode() + ")"));
    }

    private void createEmptyIndex() throws IndexingException {
        try {
            Document document = new Document();
            document.add((Fieldable)new Field("__dummy__", "__dummy__", Field.Store.YES, Field.Index.UN_TOKENIZED));
            this.getWriter(true);
            this.writer.addDocument(document);
            this.writer.deleteDocuments(new Term("__dummy__", "__dummy__"));
            this.writer.optimize();
            this.closeWriter(PhysicalLuceneIndex.CloseMode.COMMIT);
        }
        catch (Exception exception) {
            try {
                this.closeWriter(PhysicalLuceneIndex.CloseMode.ROLLBACK);
            }
            catch (Exception exception2) {
                log.error((Object)"Could not close writer while in catch block of another error", (Throwable)exception2);
            }
            log.error((Object)("Creation of empty index failed (path=" + this.indexDir.getAbsolutePath() + ")"), (Throwable)exception);
            throw new IndexingException("Creation of empty index failed (path=" + this.indexDir.getAbsolutePath() + ")", (Throwable)exception);
        }
    }

    @Override
    public void open() throws IndexAlreadyOpenedException, ObjectDestroyedException {
        if (this.destroyed) {
            throw new ObjectDestroyedException("Physical Lucene index has been destroyed");
        }
        if (this.opened) {
            throw new IndexAlreadyOpenedException("Physical Lucene index already opened");
        }
        this.opened = true;
    }

    @Override
    public synchronized void addDocuments(Collection<LuceneDocument> collection) throws SearchException {
        if (this.destroyed) {
            throw new ObjectDestroyedException("Physical Lucene index has been destroyed");
        }
        if (!this.opened) {
            throw new IndexNotOpenedException("Index has not been opened");
        }
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        for (LuceneDocument luceneDocument : collection) {
            arrayList.add(luceneDocument.getId());
        }
        long l = 0L;
        try {
            this.getWriter(false);
            log.debug((Object)"Deletion of documents starts...");
            l = System.currentTimeMillis();
            for (String object : arrayList) {
                this.writer.deleteDocuments(new Term("__DOCID__", object));
            }
            log.debug((Object)("Deletion of documents finished (" + (System.currentTimeMillis() - l) + " ms). Indexing starts..."));
            l = System.currentTimeMillis();
            for (LuceneDocument luceneDocument : collection) {
                this.writer.addDocument(luceneDocument.getDocument());
            }
            log.debug((Object)("Indexing of documents chunk finished (" + (System.currentTimeMillis() - l) + " ms)"));
        }
        catch (Exception exception) {
            log.error((Object)"Error occured while adding Lucene documents.", (Throwable)exception);
            throw new IndexingException("Error occured while adding Lucene documents.", (Throwable)exception);
        }
    }

    @Override
    public synchronized void deleteDocuments(Collection<String> collection) throws SearchException {
        if (this.destroyed) {
            throw new ObjectDestroyedException("Physical Lucene index has been destroyed");
        }
        if (!this.opened) {
            throw new IndexNotOpenedException("Index has not been opened");
        }
        try {
            this.getWriter(false);
            for (String string : collection) {
                this.writer.deleteDocuments(new Term("__DOCID__", string));
            }
        }
        catch (Exception exception) {
            log.error((Object)"Deletion of Lucene documents failed.", (Throwable)exception);
            throw new IndexingException("Deletion of Lucene documents failed.", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void recreate() throws SearchException {
        if (this.destroyed) {
            throw new ObjectDestroyedException("Physical Lucene index has been destroyed");
        }
        if (!this.opened) {
            throw new IndexNotOpenedException("Index has not been opened");
        }
        log.debug((Object)("Recreation of index at [" + this.indexDir.getAbsolutePath() + "] started..."));
        try {
            FileUtils.deleteFilesFromDirectory((File)this.indexDir);
        }
        catch (Exception exception) {
            log.error((Object)("Couldn't delete index files at [" + this.indexDir.getAbsolutePath() + "]"), (Throwable)exception);
        }
        finally {
            this.createEmptyIndex();
        }
        log.debug((Object)("Recreation of index at [" + this.indexDir.getAbsolutePath() + "] successful"));
    }

    @Override
    public synchronized void optimize() throws SearchException {
        if (this.destroyed) {
            throw new ObjectDestroyedException("Physical Lucene index has been destroyed");
        }
        if (!this.opened) {
            throw new IndexNotOpenedException("Index has not been opened");
        }
        try {
            this.getWriter(false);
            this.writer.optimize();
        }
        catch (Exception exception) {
            log.error((Object)"Optimizing Lucene index failed.", (Throwable)exception);
            throw new IndexingException("Optimizing Lucene index failed.", (Throwable)exception);
        }
    }

    @Override
    public synchronized void mergeIndex(Directory directory) throws SearchException {
        if (this.destroyed) {
            throw new ObjectDestroyedException("Physical Lucene index has been destroyed");
        }
        if (!this.opened) {
            throw new IndexNotOpenedException("Index has not been opened");
        }
        try {
            this.getWriter(false);
            this.writer.addIndexes(new Directory[]{directory});
        }
        catch (Exception exception) {
            log.error((Object)"Merging index failed.", (Throwable)exception);
            throw new IndexingException("Merging index failed.", (Throwable)exception);
        }
    }

    @Override
    public synchronized void close(PhysicalLuceneIndex.CloseMode closeMode) throws SearchException {
        if (this.destroyed) {
            throw new ObjectDestroyedException("Physical Lucene index has been destroyed");
        }
        if (!this.opened) {
            throw new IndexNotOpenedException("Index has not been opened");
        }
        this.opened = false;
        this.closeWriter(closeMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void destroy() throws SearchException {
        if (!this.destroyed) {
            try {
                if (this.opened) {
                    this.close(PhysicalLuceneIndex.CloseMode.ROLLBACK);
                }
            }
            finally {
                this.destroyed = true;
                this.opened = false;
            }
        }
    }

    @Override
    public LuceneSearcherData createNativeLuceneSearcher() throws SearchException {
        if (this.destroyed) {
            throw new ObjectDestroyedException("Physical Lucene index has been destroyed");
        }
        try {
            log.info((Object)("Creating searcher for directory " + this.indexDir.getAbsolutePath() + " ..."));
            IndexSearcher indexSearcher = new IndexSearcher(this.indexDir.getAbsolutePath());
            IndexReader indexReader = indexSearcher.getIndexReader();
            return new LuceneSearcherDataImpl((Searcher)indexSearcher, indexReader, null, indexReader.getVersion(), indexReader.numDocs());
        }
        catch (Exception exception) {
            log.error((Object)"Error occured while creating Lucene native searcher", (Throwable)exception);
            throw new SearchException("Error occured while creating Lucene native searcher", (Throwable)exception);
        }
    }

    private void getWriter(boolean bl) throws IndexingException {
        try {
            if (bl) {
                this.closeWriter(PhysicalLuceneIndex.CloseMode.ROLLBACK);
            }
            if (this.writer == null) {
                this.writer = new IndexWriter((Directory)FSDirectory.getDirectory((File)this.indexDir), false, this.analyzerFactory.getAnalyzer(), bl);
                this.writer.setMaxFieldLength(this.maxFieldLength);
                this.writer.setRAMBufferSizeMB(this.ramBufferSizeMB);
                this.writer.setMaxMergeDocs(this.maxMergeDocs);
                this.writer.setMergeFactor(this.mergeFactor);
            }
        }
        catch (Exception exception) {
            log.error((Object)"IO error while getting writer.", (Throwable)exception);
            throw new IndexingException("IO error while getting writer.", (Throwable)exception);
        }
    }

    private void closeWriter(PhysicalLuceneIndex.CloseMode closeMode) throws IndexingException {
        try {
            if (this.writer != null) {
                IndexWriter indexWriter = this.writer;
                this.writer = null;
                if (closeMode == PhysicalLuceneIndex.CloseMode.COMMIT) {
                    indexWriter.close();
                } else {
                    indexWriter.abort();
                }
            }
        }
        catch (Exception exception) {
            throw new IndexingException("Couldn't close writer.", (Throwable)exception);
        }
    }

    public AnalyzerFactory getAnalyzerFactory() {
        return this.analyzerFactory;
    }

    public void setAnalyzerFactory(AnalyzerFactory analyzerFactory) {
        this.analyzerFactory = analyzerFactory;
    }

    public int getMaxFieldLength() {
        return this.maxFieldLength;
    }

    public void setMaxFieldLength(int n) {
        this.maxFieldLength = n;
    }

    public int getMaxMergeDocs() {
        return this.maxMergeDocs;
    }

    public void setMaxMergeDocs(int n) {
        this.maxMergeDocs = n;
    }

    public int getMergeFactor() {
        return this.mergeFactor;
    }

    public void setMergeFactor(int n) {
        this.mergeFactor = n;
    }

    @Override
    public boolean isOpened() {
        return this.opened;
    }

    public double getRamBufferSizeMB() {
        return this.ramBufferSizeMB;
    }

    public void setRamBufferSizeMB(double d) {
        this.ramBufferSizeMB = d;
    }

    public File getIndexDir() {
        return this.indexDir;
    }
}

