/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.module.config.impl;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import pl.edu.icm.yadda.common.utils.Utils;
import pl.edu.icm.yadda.service.search.errors.SearchConfigException;
import pl.edu.icm.yadda.service.search.module.config.FieldMetadata;
import pl.edu.icm.yadda.service.search.module.config.IndexMetadata;
import pl.edu.icm.yadda.service.search.module.config.impl.FieldMetadataImpl;
import pl.edu.icm.yadda.service.search.utils.AnalyzerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesMetadataFactory {
    private static final Log log = LogFactory.getLog(PropertiesMetadataFactory.class);
    public static final String P_FIELD_PREFIX = "field.";
    public static final String P_DEFAULT_ANALYZER = "default_analyzer_class";
    public static final String FP_TOKENIZED = "tokenized";
    public static final String FP_UNTOKENIZED = "untokenized";
    public static final String FP_UNINDEXED = "unindexed";
    public static final String FP_STORED = "stored";
    public static final String FP_UNSTORED = "unstored";
    public static final String FP_COMPRESSED = "compressed";
    public static final String FP_SPAN = "span";
    public static final String FP_SORTABLE = "sortable";
    public static final String FP_ANALYZER_CLASS = "analyzer";

    public static void parseMetadataProperties(Properties properties, IndexMetadata indexMetadata) throws SearchConfigException {
        String string = properties.getProperty(P_DEFAULT_ANALYZER);
        if (string == null) {
            throw new SearchConfigException("Property 'default_analyzer_class' is not set");
        }
        Class<? extends Analyzer> clazz = AnalyzerUtils.getAnalyzerClass(string);
        indexMetadata.setDefaultAnalyzerClass(clazz);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String string2 = (String)entry.getKey();
            if (string2.equals(P_DEFAULT_ANALYZER)) continue;
            if (string2.startsWith(P_FIELD_PREFIX)) {
                string2 = string2.substring(P_FIELD_PREFIX.length());
                indexMetadata.addFieldMetadata(PropertiesMetadataFactory.parseFieldMetadata(string2, (String)entry.getValue(), clazz));
                continue;
            }
            String string3 = (String)entry.getValue();
            indexMetadata.setSpecialConfigProperty((String)entry.getKey(), string3.trim());
        }
    }

    private static FieldMetadata parseFieldMetadata(String string, String string2, Class<? extends Analyzer> clazz) throws SearchConfigException {
        String[] stringArray = string2.split(",");
        FieldMetadataImpl fieldMetadataImpl = new FieldMetadataImpl();
        fieldMetadataImpl.setName(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3;
            String string4 = stringArray[i].trim();
            if (Utils.emptyStr((String)string4)) continue;
            if (FP_TOKENIZED.equals(string4)) {
                fieldMetadataImpl.setIndexed(Field.Index.TOKENIZED);
                continue;
            }
            if (FP_UNTOKENIZED.equals(string4)) {
                fieldMetadataImpl.setIndexed(Field.Index.UN_TOKENIZED);
                continue;
            }
            if (FP_UNINDEXED.equals(string4)) {
                fieldMetadataImpl.setIndexed(Field.Index.NO);
                continue;
            }
            if (FP_STORED.equals(string4)) {
                fieldMetadataImpl.setStored(Field.Store.YES);
                continue;
            }
            if (FP_UNSTORED.equals(string4)) {
                fieldMetadataImpl.setStored(Field.Store.NO);
                continue;
            }
            if (FP_COMPRESSED.equals(string4)) {
                fieldMetadataImpl.setStored(Field.Store.COMPRESS);
                continue;
            }
            if (string4.startsWith(FP_SPAN)) {
                string3 = string4.substring(FP_SPAN.length());
                if (string3.length() == 0 || !Character.isWhitespace(string3.charAt(0))) {
                    throw new SearchConfigException("Index field '" + string + "' has wrong span property (" + string4 + ")");
                }
                int n = Utils.atoi((String)string3.trim());
                if (n < 0) {
                    throw new SearchConfigException("Index field '" + string + "' has wrong span property (" + string4 + ")");
                }
                fieldMetadataImpl.setSpan(n);
                continue;
            }
            if (string4.startsWith(FP_ANALYZER_CLASS)) {
                string3 = string4.substring(FP_ANALYZER_CLASS.length());
                if (string3.length() == 0 || !Character.isWhitespace(string3.charAt(0))) {
                    throw new SearchConfigException("Index field '" + string + "' has wrong analyzer class property (" + string4 + ")");
                }
                fieldMetadataImpl.setAnalyzerClass(AnalyzerUtils.getAnalyzerClass(string3.trim()));
                continue;
            }
            if (FP_SORTABLE.equals(string4)) {
                fieldMetadataImpl.setSortable(true);
                continue;
            }
            log.warn((Object)("Field '" + string + "' has property of unknown type (" + string4 + ") which will be used as a default analyzer class"));
            fieldMetadataImpl.setAnalyzerClass(AnalyzerUtils.getAnalyzerClass(string4));
        }
        if (fieldMetadataImpl.getIndexed() == null) {
            fieldMetadataImpl.setIndexed(Field.Index.TOKENIZED);
        }
        if (fieldMetadataImpl.getStored() == null) {
            fieldMetadataImpl.setStored(Field.Store.NO);
        }
        if (fieldMetadataImpl.getIndexed() == Field.Index.NO && fieldMetadataImpl.getStored() == Field.Store.NO) {
            throw new SearchConfigException("Index field '" + string + "' has both " + FP_UNINDEXED + " and " + FP_UNSTORED + " params set.");
        }
        if (fieldMetadataImpl.getIndexed() == Field.Index.TOKENIZED && fieldMetadataImpl.getAnalyzerClass() == null) {
            if (clazz == null) {
                throw new SearchConfigException("Index field '" + string + "' is " + FP_TOKENIZED + " but doesn't have analyzer class assigned.");
            }
            fieldMetadataImpl.setAnalyzerClass(clazz);
        } else if (fieldMetadataImpl.getIndexed() != Field.Index.TOKENIZED) {
            if (fieldMetadataImpl.getAnalyzerClass() != null) {
                throw new SearchConfigException("Index field '" + string + "' has assigned analyzer class but is not tokenized");
            }
            if (fieldMetadataImpl.getSpan() > -1) {
                throw new SearchConfigException("Index field '" + string + "' is not tokenized but has span");
            }
        }
        return fieldMetadataImpl;
    }

    public static Properties convertIndexMetadataToProperties(IndexMetadata indexMetadata) throws SearchConfigException {
        Properties properties = new Properties();
        if (indexMetadata.getDefaultAnalyzerClass() == null) {
            throw new SearchConfigException("Metadata does not have default analyzer class");
        }
        properties.setProperty(P_DEFAULT_ANALYZER, indexMetadata.getDefaultAnalyzerClass().getCanonicalName());
        for (FieldMetadata object : indexMetadata.getAllFieldsMetadata()) {
            String[] stringArray = PropertiesMetadataFactory.fieldMetadataToProperty(object);
            properties.setProperty(stringArray[0], stringArray[1]);
        }
        for (Map.Entry entry : indexMetadata.getSpecialConfigProperties().entrySet()) {
            properties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return properties;
    }

    private static String[] fieldMetadataToProperty(FieldMetadata fieldMetadata) throws SearchConfigException {
        String[] stringArray = new String[2];
        stringArray[0] = P_FIELD_PREFIX + fieldMetadata.getName();
        StringBuffer stringBuffer = new StringBuffer();
        Field.Index index = fieldMetadata.getIndexed();
        if (index == Field.Index.NO) {
            stringBuffer.append(FP_UNINDEXED);
        } else if (index == Field.Index.TOKENIZED) {
            stringBuffer.append(FP_TOKENIZED);
        } else if (index == Field.Index.UN_TOKENIZED) {
            stringBuffer.append(FP_UNTOKENIZED);
        } else {
            throw new SearchConfigException("Unknown field metadata 'indexed' value [" + index + "]");
        }
        stringBuffer.append(", ");
        Field.Store store = fieldMetadata.getStored();
        if (store == Field.Store.YES) {
            stringBuffer.append(FP_STORED);
        } else if (store == Field.Store.NO) {
            stringBuffer.append(FP_UNSTORED);
        } else if (store == Field.Store.COMPRESS) {
            stringBuffer.append(FP_COMPRESSED);
        } else {
            throw new SearchConfigException("Unknown field metadata 'stored' value [" + store + "]");
        }
        if (fieldMetadata.isSpan()) {
            stringBuffer.append(", ").append(FP_SPAN).append(" ").append(fieldMetadata.getSpan());
        }
        if (fieldMetadata.isSortable()) {
            stringBuffer.append(", ").append(FP_SORTABLE);
        }
        if (fieldMetadata.getAnalyzerClass() != null) {
            stringBuffer.append(", ").append(FP_ANALYZER_CLASS).append(" ").append(fieldMetadata.getAnalyzerClass().getCanonicalName());
        }
        stringArray[1] = stringBuffer.toString();
        return stringArray;
    }
}

