/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.module.impl;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pl.edu.icm.yadda.service.search.SearchException;
import pl.edu.icm.yadda.service.search.errors.NoSuchIndexException;
import pl.edu.icm.yadda.service.search.module.DynamicMultiIndexFactory;
import pl.edu.icm.yadda.service.search.module.Index;
import pl.edu.icm.yadda.service.search.module.MultiIndex;
import pl.edu.icm.yadda.service.search.module.SearchModule;
import pl.edu.icm.yadda.service.search.module.impl.IndexSelector;
import pl.edu.icm.yadda.service.search.module.impl.MultiIndexDynamicImpl;
import pl.edu.icm.yadda.service.search.searching.impl.SearcherImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicMultiIndexFactoryImpl
implements DynamicMultiIndexFactory {
    private static final Log log = LogFactory.getLog(DynamicMultiIndexFactoryImpl.class);
    private SearchModule searchModule;

    public DynamicMultiIndexFactoryImpl() {
    }

    public DynamicMultiIndexFactoryImpl(SearchModule searchModule) {
        this.searchModule = searchModule;
    }

    @Override
    public MultiIndex createMultiIndex(Set<String> indexNames) throws SearchException {
        HashSet<Index> indexes = new HashSet<Index>();
        StringBuffer nameBuf = new StringBuffer();
        for (String indexName : indexNames) {
            Index index = this.searchModule.getIndex(indexName);
            if (index == null) {
                throw new SearchException("Set multi-index could not be created (index '" + indexName + "' does not exist");
            }
            if (!index.isSingle()) {
                log.warn((Object)("Dynamic multi index contains non-single index '" + indexName + "'"));
            }
            indexes.add(index);
            if (nameBuf.length() > 0) {
                nameBuf.append("##");
            }
            nameBuf.append(indexName);
        }
        return this.doCreateMultiIndex(nameBuf.toString(), indexes, null);
    }

    @Override
    public MultiIndex createMultiIndex(String indexName, IndexSelector selector, boolean allowEmpty) throws SearchException {
        HashSet<Index> indexes = new HashSet<Index>();
        for (String indName : this.searchModule.listIndexNames(true)) {
            Index index = this.searchModule.getIndex(indName);
            if (!selector.accept(index)) continue;
            indexes.add(index);
        }
        if (indexes.isEmpty() && !allowEmpty) {
            throw new NoSuchIndexException("Subindex set for multi-index with selector is empty");
        }
        return this.doCreateMultiIndex(indexName, indexes, selector);
    }

    private MultiIndexDynamicImpl doCreateMultiIndex(String indexName, Set<Index> subindexes, IndexSelector selector) throws SearchException {
        MultiIndexDynamicImpl multiIndex = new MultiIndexDynamicImpl();
        String suffix = null;
        if (indexName != null) {
            suffix = indexName;
        } else {
            suffix = String.valueOf(System.currentTimeMillis());
            indexName = "multiIndex." + suffix;
        }
        if (selector != null) {
            multiIndex.setMutable(true);
        }
        multiIndex.setName(indexName);
        multiIndex.setSubindexes(subindexes);
        multiIndex.setIndexSelector(selector);
        SearcherImpl searcher = new SearcherImpl();
        searcher.setId("searcher." + suffix);
        multiIndex.setSearcher(searcher);
        multiIndex.setSearchModule(this.searchModule);
        multiIndex.init();
        return multiIndex;
    }

    @Override
    public void setSearchModule(SearchModule searchModule) {
        this.searchModule = searchModule;
    }
}

