/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.module.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pl.edu.icm.yadda.common.utils.Utils;
import pl.edu.icm.yadda.service.search.SearchException;
import pl.edu.icm.yadda.service.search.errors.ObjectDestroyedException;
import pl.edu.icm.yadda.service.search.errors.SearchMultiExceptionFactory;
import pl.edu.icm.yadda.service.search.indexing.Indexer;
import pl.edu.icm.yadda.service.search.module.Index;
import pl.edu.icm.yadda.service.search.module.SearchModule;
import pl.edu.icm.yadda.service.search.module.config.IndexConfiguration;
import pl.edu.icm.yadda.service.search.module.config.LuceneSearcherData;
import pl.edu.icm.yadda.service.search.module.config.impl.LuceneSearcherDataImpl;
import pl.edu.icm.yadda.service.search.module.event.IndexEventListener;
import pl.edu.icm.yadda.service.search.searching.Searcher;

public abstract class IndexAbstractImpl
implements Index {
    private static final Log log = LogFactory.getLog(IndexAbstractImpl.class);
    protected SearchModule searchModule;
    protected String name;
    protected Indexer indexer;
    protected Searcher searcher;
    protected LuceneSearcherDataImpl luceneSearcherData;
    protected Object configMutex = new Object();
    private long lastSearcherDataCheck = 0L;
    private static final int SEARCHER_DATA_CHECK_INTERVAL = 600000;
    private boolean destroyed = false;
    protected boolean active = true;
    protected Collection<IndexEventListener> eventListeners = new LinkedHashSet<IndexEventListener>();

    public Indexer getIndexer() {
        return this.indexer;
    }

    public void setIndexer(Indexer indexer) {
        this.indexer = indexer;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Searcher getSearcher() {
        return this.searcher;
    }

    public void setSearcher(Searcher searcher) {
        this.searcher = searcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LuceneSearcherData getLuceneSearcherData() throws SearchException {
        Object object = this.configMutex;
        synchronized (object) {
            if (this.destroyed) {
                throw new ObjectDestroyedException("Index '" + this.name + "' is destroyed and can not be used");
            }
            if (!this.active) {
                throw new SearchException("Index '" + this.name + "' is not active and can not be searched");
            }
            this.checkIfLuceneSearcherDataCurrent();
            if (this.luceneSearcherData == null) {
                IndexConfiguration config = this.getIndexConfiguration();
                this.luceneSearcherData = (LuceneSearcherDataImpl)config.createLuceneSearcher();
                if (this.luceneSearcherData == null) {
                    return null;
                }
                this.luceneSearcherData.setIndexName(this.name);
            }
            this.luceneSearcherData.acquire();
            return this.luceneSearcherData;
        }
    }

    private void checkIfLuceneSearcherDataCurrent() throws SearchException {
        if (System.currentTimeMillis() - this.lastSearcherDataCheck > 600000L) {
            this.lastSearcherDataCheck = System.currentTimeMillis();
            try {
                if (this.luceneSearcherData != null && !this.luceneSearcherData.getIndexReader().isCurrent()) {
                    log.debug((Object)("Lucene searcher data is not current (index: " + this.name + ")"));
                    this.doIndexChangedEvent();
                } else {
                    log.debug((Object)("Lucene searcher data is current (index: " + this.name + ")"));
                }
            }
            catch (Exception e) {
                throw new SearchException("Up-to-date check of Lucene searcher data failed (index: " + this.name + ")", (Throwable)e);
            }
        }
    }

    public int getDocumentCount() throws SearchException {
        LuceneSearcherData searcherData = null;
        try {
            searcherData = this.getLuceneSearcherData();
            int n = searcherData == null ? 0 : searcherData.getDocumentsNumber();
            return n;
        }
        finally {
            if (searcherData != null) {
                searcherData.release();
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) throws SearchException {
        this.active = active;
        ArrayList<SearchException> errors = null;
        if (!active) {
            try {
                this.closeLuceneSearcherData();
            }
            catch (SearchException e) {
                if (errors == null) {
                    errors = new ArrayList<SearchException>();
                }
                errors.add(e);
            }
        }
        for (IndexEventListener listener : this.eventListeners) {
            try {
                listener.activityChangedEvent(active, this);
            }
            catch (SearchException e) {
                if (errors == null) {
                    errors = new ArrayList();
                }
                errors.add(e);
            }
        }
        if (!Utils.emptyCollection(errors)) {
            throw SearchMultiExceptionFactory.createException("Error occured while populating 'index activity changed' event", errors);
        }
    }

    public void addEventListener(IndexEventListener listener) {
        this.eventListeners.add(listener);
    }

    public void removeEventListener(IndexEventListener listener) {
        this.eventListeners.remove(listener);
    }

    public void doIndexChangedEvent() throws SearchException {
        ArrayList<SearchException> errors = null;
        try {
            this.closeLuceneSearcherData();
        }
        catch (SearchException e) {
            if (errors == null) {
                errors = new ArrayList<SearchException>();
            }
            errors.add(e);
        }
        for (IndexEventListener listener : this.eventListeners) {
            try {
                listener.indexChangedEvent(this);
            }
            catch (SearchException e) {
                if (errors == null) {
                    errors = new ArrayList();
                }
                errors.add(e);
            }
        }
        if (!Utils.emptyCollection(errors)) {
            throw SearchMultiExceptionFactory.createException("Error occured while populating 'index changed' event", errors);
        }
    }

    public void doIndexRemovedEvent() throws SearchException {
        ArrayList<SearchException> errors = null;
        for (IndexEventListener listener : this.eventListeners) {
            try {
                listener.indexRemovedEvent(this);
            }
            catch (SearchException e) {
                if (errors == null) {
                    errors = new ArrayList();
                }
                errors.add(e);
            }
        }
        this.eventListeners.clear();
        try {
            this.destroy();
        }
        catch (SearchException e) {
            if (errors == null) {
                errors = new ArrayList<SearchException>();
            }
            errors.add(e);
        }
        if (!Utils.emptyCollection(errors)) {
            throw SearchMultiExceptionFactory.createException("Error occured while populating 'index removed' event", errors);
        }
    }

    public SearchModule getSearchModule() {
        return this.searchModule;
    }

    public void setSearchModule(SearchModule searchModule) {
        this.searchModule = searchModule;
    }

    public void setAddToSearchModule(SearchModule searchModule) throws SearchException {
        this.searchModule = searchModule;
        searchModule.addIndex(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeLuceneSearcherData() throws SearchException {
        Object object = this.configMutex;
        synchronized (object) {
            if (this.luceneSearcherData != null) {
                LuceneSearcherDataImpl old = this.luceneSearcherData;
                this.luceneSearcherData = null;
                old.close();
            }
        }
    }

    public void destroy() throws SearchException {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        ArrayList<Exception> errors = null;
        try {
            this.closeLuceneSearcherData();
        }
        catch (Exception e) {
            if (errors == null) {
                errors = new ArrayList<Exception>();
            }
            errors.add(e);
        }
        if (this.indexer != null) {
            try {
                this.indexer.destroy();
            }
            catch (Exception e) {
                if (errors == null) {
                    errors = new ArrayList();
                }
                errors.add(e);
            }
        }
        if (!Utils.emptyCollection((Collection)errors)) {
            throw SearchMultiExceptionFactory.createException("Error while destroying index '" + this.name + "'", errors);
        }
    }
}

