/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.module.impl;

import pl.edu.icm.yadda.service.search.SearchException;
import pl.edu.icm.yadda.service.search.errors.SearchConfigException;
import pl.edu.icm.yadda.service.search.indexing.impl.IndexerImpl;
import pl.edu.icm.yadda.service.search.module.config.IndexConfiguration;
import pl.edu.icm.yadda.service.search.module.config.IndexConfigurationSingle;
import pl.edu.icm.yadda.service.search.module.impl.IndexAbstractImpl;
import pl.edu.icm.yadda.service.search.searching.impl.SearcherImpl;

public class IndexSingleImpl
extends IndexAbstractImpl {
    private IndexConfigurationSingle indexConfiguration;
    private boolean initialized = false;

    public boolean isSingle() {
        return true;
    }

    public void init() throws SearchException {
        if (!this.initialized) {
            this.initialized = true;
            if (this.indexConfiguration == null) {
                throw new SearchConfigException("Index '" + this.name + "' have null index configuration");
            }
            this.indexConfiguration.setIndexId(this.name);
            this.indexConfiguration.init();
            if (this.indexer == null) {
                this.indexer = new IndexerImpl();
                this.indexer.setId(this.name + ".indexer");
            }
            if (this.searcher == null) {
                this.searcher = new SearcherImpl();
                this.searcher.setId(this.name + ".searcher");
            }
            this.indexer.init(this);
            this.searcher.init(this);
        }
    }

    public IndexConfiguration getIndexConfiguration() {
        return this.indexConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndexConfiguration(IndexConfiguration indexConfiguration) throws SearchConfigException {
        if (!(indexConfiguration instanceof IndexConfigurationSingle)) {
            throw new SearchConfigException("Single index expects single index configuration");
        }
        Object object = this.configMutex;
        synchronized (object) {
            this.indexConfiguration = (IndexConfigurationSingle)indexConfiguration;
        }
    }
}

