/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.module.impl;

import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import pl.edu.icm.yadda.common.utils.Utils;
import pl.edu.icm.yadda.service.search.SearchException;
import pl.edu.icm.yadda.service.search.errors.SearchConfigException;
import pl.edu.icm.yadda.service.search.module.Index;
import pl.edu.icm.yadda.service.search.module.config.FieldMetadata;
import pl.edu.icm.yadda.service.search.module.config.impl.IndexConfigurationMultiImpl;
import pl.edu.icm.yadda.service.search.module.config.impl.IndexMetadataImpl;
import pl.edu.icm.yadda.service.search.module.impl.ConfigHolder;
import pl.edu.icm.yadda.service.search.module.impl.IndexSelector;
import pl.edu.icm.yadda.service.search.module.impl.MultiIndexImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiIndexDynamicImpl
extends MultiIndexImpl {
    private static final Log log = LogFactory.getLog(MultiIndexDynamicImpl.class);
    private boolean mutable = false;
    private boolean allowConfigConflicts = true;
    private IndexSelector indexSelector;

    @Override
    public void setSubindexes(Collection<? extends Index> collection) throws SearchException {
        super.setSubindexes(collection);
        this.mergeConfigurations();
    }

    private void mergeConfigurations() throws SearchException {
        IndexConfigurationMultiImpl indexConfigurationMultiImpl = null;
        if (!Utils.emptyCollection((Collection)this.subindexes)) {
            Object object;
            Class<? extends Analyzer> clazz = null;
            HashMap<String, FieldMetadata> hashMap = new HashMap<String, FieldMetadata>();
            HashMap<String, ConfigHolder<FieldMetadata>> hashMap2 = new HashMap<String, ConfigHolder<FieldMetadata>>();
            ConfigHolder<Class<? extends Analyzer>> configHolder = new ConfigHolder<Class<? extends Analyzer>>();
            for (Object object2 : this.subindexes) {
                object = object2.getIndexConfiguration().getIndexMetadata();
                Class<? extends Analyzer> clazz2 = object.getDefaultAnalyzerClass();
                if (this.allowConfigConflicts && clazz2 != null) {
                    configHolder.addConfigObject(clazz2);
                }
                if (clazz == null) {
                    clazz = clazz2;
                } else if (clazz != clazz2 && !this.allowConfigConflicts) {
                    throw new SearchConfigException("Creation of dynamic multi index failed -  default analyzer class conflict - (" + clazz.getCanonicalName() + ", " + clazz2.getCanonicalName() + ")");
                }
                for (FieldMetadata fieldMetadata : object.getAllFieldsMetadata()) {
                    FieldMetadata fieldMetadata2 = (FieldMetadata)hashMap.get(fieldMetadata.getName());
                    if (fieldMetadata2 == null) {
                        hashMap.put(fieldMetadata.getName(), fieldMetadata);
                    } else if (!fieldMetadata2.equals(fieldMetadata) && !this.allowConfigConflicts) {
                        throw new SearchConfigException("Creation of dynamic multi indexer failed - field metadata conflict (field name=" + fieldMetadata.getName() + ")");
                    }
                    if (!this.allowConfigConflicts) continue;
                    ConfigHolder<FieldMetadata> configHolder2 = (ConfigHolder<FieldMetadata>)hashMap2.get(fieldMetadata.getName());
                    if (configHolder2 == null) {
                        configHolder2 = new ConfigHolder<FieldMetadata>();
                        hashMap2.put(fieldMetadata.getName(), configHolder2);
                    }
                    configHolder2.addConfigObject(fieldMetadata);
                }
            }
            if (configHolder.hasConflicts()) {
                clazz = (Class<? extends Analyzer>)configHolder.getBestObject();
                log.warn((Object)("Multi-index '" + this.name + "' has conflicting default analyzers (winner: " + clazz.getCanonicalName() + ")"));
            }
            for (Object object2 : hashMap2.values()) {
                if (!((ConfigHolder)object2).hasConflicts()) continue;
                object = (FieldMetadata)((ConfigHolder)object2).getBestObject();
                hashMap.put(object.getName(), (FieldMetadata)object);
                log.warn((Object)("Multi-index '" + this.name + "' has conflicting fields '" + object.getName() + "' (winner: [" + object + "])"));
            }
            IndexMetadataImpl indexMetadataImpl = new IndexMetadataImpl();
            indexMetadataImpl.setDefaultAnalyzerClass(clazz);
            indexMetadataImpl.setFieldsMetadata(hashMap);
            indexMetadataImpl.init();
            indexConfigurationMultiImpl = new IndexConfigurationMultiImpl();
            indexConfigurationMultiImpl.setIndexId(this.name);
            indexConfigurationMultiImpl.setIndexMetadata(indexMetadataImpl);
        } else {
            if (!this.mutable) {
                throw new SearchConfigException("Immutable multi index has empty subindex collection");
            }
            indexConfigurationMultiImpl = new IndexConfigurationMultiImpl();
            indexConfigurationMultiImpl.setIndexId(this.name);
            indexConfigurationMultiImpl.setNullMetadataAllowed(true);
            indexConfigurationMultiImpl.setEmptySubindexListAllowed(true);
        }
        indexConfigurationMultiImpl.setSubindexes(this.subindexes);
        indexConfigurationMultiImpl.init();
        this.setIndexConfiguration(indexConfigurationMultiImpl);
    }

    @Override
    public void indexRemovedEvent(Index index) {
        try {
            if (this.subindexes.contains(index)) {
                if (!this.mutable) {
                    this.searchModule.removeIndex(this);
                } else {
                    this.subindexes.remove(index);
                    this.subindexSetChanged();
                }
            }
        }
        catch (SearchException searchException) {
            log.error((Object)"Error occured while removing dynamic multi index after subindex removal", (Throwable)searchException);
        }
    }

    @Override
    public void indexAddedEvent(Index index) throws SearchException {
        if (this.mutable && index.isSingle() && (this.indexSelector == null || this.indexSelector.accept(index))) {
            this.subindexes.add(index);
            index.addEventListener(this);
            this.subindexSetChanged();
        }
    }

    private void subindexSetChanged() throws SearchException {
        this.mergeConfigurations();
        this.doIndexChangedEvent();
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void setMutable(boolean bl) {
        this.mutable = bl;
    }

    public boolean isAllowConfigConflicts() {
        return this.allowConfigConflicts;
    }

    public void setAllowConfigConflicts(boolean bl) {
        this.allowConfigConflicts = bl;
    }

    public IndexSelector getIndexSelector() {
        return this.indexSelector;
    }

    public void setIndexSelector(IndexSelector indexSelector) {
        this.indexSelector = indexSelector;
    }

    @Override
    public void destroy() throws SearchException {
        this.searchModule.removeModuleEventListener(this);
        super.destroy();
    }
}

