/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.module.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pl.edu.icm.yadda.service.search.SearchException;
import pl.edu.icm.yadda.service.search.errors.SearchConfigException;
import pl.edu.icm.yadda.service.search.module.Index;
import pl.edu.icm.yadda.service.search.module.MultiIndex;
import pl.edu.icm.yadda.service.search.module.config.IndexConfiguration;
import pl.edu.icm.yadda.service.search.module.config.IndexConfigurationMulti;
import pl.edu.icm.yadda.service.search.module.impl.IndexAbstractImpl;
import pl.edu.icm.yadda.service.search.searching.impl.SearcherImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiIndexImpl
extends IndexAbstractImpl
implements MultiIndex {
    private boolean initialized = false;
    protected List<Index> subindexes = new ArrayList<Index>();
    protected IndexConfigurationMulti indexConfiguration;

    @Override
    public boolean isSingle() {
        return false;
    }

    @Override
    public Collection<? extends Index> getSubindexes() {
        return this.subindexes;
    }

    @Override
    public void setSubindexes(Collection<? extends Index> collection) throws SearchException {
        this.subindexes.clear();
        for (Index index : collection) {
            if (this.subindexes.contains(index)) continue;
            this.subindexes.add(index);
            index.addEventListener(this);
        }
    }

    @Override
    public void init() throws SearchException {
        if (!this.initialized) {
            this.initialized = true;
            for (Index index : this.subindexes) {
                index.init();
            }
            if (this.indexConfiguration == null) {
                throw new SearchConfigException("Multi index '" + this.name + "' has null index configuration");
            }
            this.indexConfiguration.setIndexId(this.name);
            this.indexConfiguration.setSubindexes(this.subindexes);
            this.indexConfiguration.init();
            if (this.indexer != null) {
                this.indexer.init(this);
            }
            if (this.searcher == null) {
                this.searcher = new SearcherImpl();
                this.searcher.setId(this.name + ".searcher");
            }
            this.searcher.init(this);
        }
    }

    @Override
    public void destroy() throws SearchException {
        for (Index index : this.subindexes) {
            index.removeEventListener(this);
        }
        this.subindexes.clear();
        super.destroy();
    }

    @Override
    public void activityChangedEvent(boolean bl, Index index) throws SearchException {
        if (this.subindexes.contains(index)) {
            this.doIndexChangedEvent();
        }
    }

    @Override
    public void indexChangedEvent(Index index) throws SearchException {
        if (this.subindexes.contains(index)) {
            this.doIndexChangedEvent();
        }
    }

    @Override
    public void indexRemovedEvent(Index index) throws SearchException {
        if (this.subindexes.contains(index)) {
            this.subindexes.remove(index);
            this.doIndexChangedEvent();
        }
    }

    @Override
    public void indexAddedEvent(Index index) throws SearchException {
    }

    @Override
    public IndexConfiguration getIndexConfiguration() {
        return this.indexConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIndexConfiguration(IndexConfiguration indexConfiguration) throws SearchException {
        if (!(indexConfiguration instanceof IndexConfigurationMulti)) {
            throw new SearchConfigException("Multi index expects multi configuration");
        }
        Object object = this.configMutex;
        synchronized (object) {
            this.indexConfiguration = (IndexConfigurationMulti)indexConfiguration;
            this.closeLuceneSearcherData();
        }
    }
}

