/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.module.impl;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pl.edu.icm.yadda.common.utils.FileUtils;
import pl.edu.icm.yadda.common.utils.XmlUtils;
import pl.edu.icm.yadda.service.search.SearchException;
import pl.edu.icm.yadda.service.search.errors.SearchConfigException;
import pl.edu.icm.yadda.service.search.module.PersistentIndexManager;
import pl.edu.icm.yadda.service.search.module.SearchModule;
import pl.edu.icm.yadda.service.search.module.config.IndexMetadata;
import pl.edu.icm.yadda.service.search.module.config.impl.PropertiesMetadataFactory;
import pl.edu.icm.yadda.spring.utils.DynamicContextLoader;

public class PersistentIndexManagerImpl
implements PersistentIndexManager {
    private static final Log log = LogFactory.getLog(PersistentIndexManagerImpl.class);
    private static final String CONFIG_FILE_PREFIX = "index-";
    private static final String T_INDEX_BEAN = "__INDEX_BEAN__";
    private static final String T_INDEX_ID = "__INDEX_ID__";
    private static final String T_INDEX_PATH = "__INDEX_PATH__";
    private static final String T_DYNAMIC_INDEXES_DIR_PROPERTY = "__DYNAMIC_INDEXES_DIR_PROPERTY__";
    private static final String T_METADATA_DEFINITION = "__METADATA_DEFINITION__";
    private static final String T_METADATA_PROPERTIES = "__METADATA_PROPERTIES__";
    private static final String T_METADATA_BEAN = "__METADATA_BEAN__";
    private File configDir;
    private DynamicContextLoader contextLoader;
    private SearchModule searchModule;
    private String configTemplate;
    private String metadataBeanTemplate;
    private String metadataPropertiesTemplate;
    private String dynamicIndexesDirPropertyName = null;
    private static final Pattern NON_BEAN_CHARACTER = Pattern.compile("[^\\p{L}\\d.\\-_:]");

    public void addIndex(String indexId, IndexMetadata indexMetadata) throws SearchConfigException {
        if (this.configTemplate == null) {
            this.loadConfigTemplates();
        }
        Properties props = PropertiesMetadataFactory.convertIndexMetadataToProperties(indexMetadata);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            props.store(out, "Metadata for index [" + indexId + "]");
        }
        catch (Exception e) {
            throw new SearchConfigException("Could not convert properties to string");
        }
        String propsString = new String(out.toByteArray());
        String metadata = this.metadataPropertiesTemplate.replace(T_METADATA_PROPERTIES, XmlUtils.escape((String)propsString));
        this.doAddIndex(indexId, metadata);
    }

    public void addIndex(String indexId, String indexMetadataBean) throws SearchConfigException {
        if (this.configTemplate == null) {
            this.loadConfigTemplates();
        }
        String metadata = this.metadataBeanTemplate.replace(T_METADATA_BEAN, XmlUtils.escape((String)indexMetadataBean));
        this.doAddIndex(indexId, metadata);
    }

    private void doAddIndex(String indexId, String metadataDef) throws SearchConfigException {
        if (this.configTemplate == null) {
            this.loadConfigTemplates();
        }
        if (this.dynamicIndexesDirPropertyName == null) {
            throw new SearchConfigException("Name of index root directory variable is not set");
        }
        String indexPath = PersistentIndexManagerImpl.normalizeIndexPath(indexId);
        String beanId = "indexBean." + NON_BEAN_CHARACTER.matcher(indexId).replaceAll("_");
        String indexConfig = this.configTemplate.replace(T_INDEX_BEAN, beanId).replace(T_METADATA_DEFINITION, metadataDef).replace(T_INDEX_ID, XmlUtils.escape((String)indexId)).replace(T_INDEX_PATH, XmlUtils.escape((String)indexPath)).replace(T_DYNAMIC_INDEXES_DIR_PROPERTY, XmlUtils.escape((String)this.dynamicIndexesDirPropertyName));
        File configFile = this.getIndexConfigFile(indexId);
        if (configFile.exists()) {
            throw new SearchConfigException("Configuration for index '" + indexId + "' already exists (" + configFile.getAbsolutePath() + ").");
        }
        try {
            FileUtils.writeToFile((File)configFile, (String)indexConfig);
            this.contextLoader.loadContext("file:" + configFile.getAbsolutePath());
        }
        catch (Exception e) {
            throw new SearchConfigException("Addition of index '" + indexId + "' failed", e);
        }
    }

    public void removeIndex(String indexId) throws SearchException {
        File configFile = this.getIndexConfigFile(indexId);
        if (!configFile.exists()) {
            log.warn((Object)("Index configuration file [" + configFile.getAbsolutePath() + "] does not exist"));
        } else if (!configFile.delete()) {
            throw new SearchConfigException("Removal of index '" + indexId + "' failed - couldn't delete configuration file '" + configFile.getAbsolutePath() + "'");
        }
        this.searchModule.removeIndex(indexId);
    }

    private static final String normalizeIndexPath(String indexId) {
        return indexId.replace('/', '_').replace('\\', '_');
    }

    private File getIndexConfigFile(String indexId) {
        return new File(this.configDir, CONFIG_FILE_PREFIX + PersistentIndexManagerImpl.normalizeIndexPath(indexId) + ".xml");
    }

    private void loadConfigTemplates() throws SearchConfigException {
        this.configTemplate = this.loadConfigTemplate("indexConfigTemplate.xml");
        this.metadataBeanTemplate = this.loadConfigTemplate("metadataBeanTemplate.xml");
        this.metadataPropertiesTemplate = this.loadConfigTemplate("metadataPropertiesTemplate.xml");
    }

    private String loadConfigTemplate(String template) throws SearchConfigException {
        URL url = this.getClass().getResource(template);
        if (url == null) {
            throw new SearchConfigException("Index configuration template (" + template + ") not found");
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), "utf-8"));
            StringBuffer buf = new StringBuffer();
            String line = reader.readLine();
            while (line != null) {
                if (buf.length() > 0) {
                    buf.append("\n");
                }
                buf.append(line);
                line = reader.readLine();
            }
            return buf.toString();
        }
        catch (Exception e) {
            throw new SearchConfigException("Could not load index configuration template (" + template + ")", e);
        }
    }

    public void setConfigPath(String path) {
        this.configDir = new File(path);
    }

    public DynamicContextLoader getContextLoader() {
        return this.contextLoader;
    }

    public void setContextLoader(DynamicContextLoader contextLoader) {
        this.contextLoader = contextLoader;
    }

    public SearchModule getSearchModule() {
        return this.searchModule;
    }

    public void setSearchModule(SearchModule searchModule) {
        this.searchModule = searchModule;
    }

    public String getDynamicIndexesDirPropertyName() {
        return this.dynamicIndexesDirPropertyName;
    }

    public void setDynamicIndexesDirPropertyName(String dynamicIndexesDirPropertyName) {
        this.dynamicIndexesDirPropertyName = dynamicIndexesDirPropertyName;
    }
}

