/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.module.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pl.edu.icm.yadda.common.utils.FileUtils;
import pl.edu.icm.yadda.common.utils.Utils;
import pl.edu.icm.yadda.service.search.SearchException;
import pl.edu.icm.yadda.service.search.errors.IndexAlreadyExists;
import pl.edu.icm.yadda.service.search.errors.NoSuchIndexException;
import pl.edu.icm.yadda.service.search.errors.SearchConfigException;
import pl.edu.icm.yadda.service.search.errors.SearchMultiExceptionFactory;
import pl.edu.icm.yadda.service.search.filter.FilterFactory;
import pl.edu.icm.yadda.service.search.filter.impl.FilterFactoryImpl;
import pl.edu.icm.yadda.service.search.module.DynamicMultiIndexFactory;
import pl.edu.icm.yadda.service.search.module.Index;
import pl.edu.icm.yadda.service.search.module.MultiIndex;
import pl.edu.icm.yadda.service.search.module.SearchModule;
import pl.edu.icm.yadda.service.search.module.config.IndexConfigurationSingle;
import pl.edu.icm.yadda.service.search.module.event.ModuleEventListener;
import pl.edu.icm.yadda.service.search.module.impl.DynamicMultiIndexFactoryImpl;
import pl.edu.icm.yadda.service.search.module.impl.IndexSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchModuleImpl
implements SearchModule {
    private static final Log log = LogFactory.getLog(SearchModuleImpl.class);
    private Map<String, Index> indexesMap = new Hashtable<String, Index>();
    private Object indexesMutex = new Object();
    private Set<ModuleEventListener> listeners = new LinkedHashSet<ModuleEventListener>();
    private Map<Set<String>, MultiIndex> setMultiIndexesMap = new Hashtable<Set<String>, MultiIndex>();
    private MultiIndex indexAll;
    private DynamicMultiIndexFactory multiIndexFactory = new DynamicMultiIndexFactoryImpl(this);
    private FilterFactory filterFactory;

    @Override
    public Index getIndex(String indexName) throws NoSuchIndexException {
        Index index = this.indexesMap.get(indexName);
        if (index == null) {
            throw new NoSuchIndexException("Index '" + indexName + "' does not exist.");
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addIndex(Index ind) throws SearchException {
        ind.init();
        if (ind.getName() == null) {
            throw new SearchConfigException("Index without name is forbidden");
        }
        if (ind.getSearcher() == null) {
            throw new SearchException("Index '" + ind.getName() + "' has no searcher");
        }
        Object object = this.indexesMutex;
        synchronized (object) {
            Index old = this.indexesMap.get(ind.getName());
            if (old != null) {
                if (old != ind) {
                    throw new IndexAlreadyExists("Index '" + ind.getName() + "' already exists");
                }
                return;
            }
            ind.getSearcher().setFilterFactory(this.filterFactory);
            this.indexesMap.put(ind.getName(), ind);
            ArrayList<SearchException> errors = null;
            for (ModuleEventListener listener : this.listeners) {
                try {
                    listener.indexAddedEvent(ind);
                }
                catch (SearchException e) {
                    if (errors == null) {
                        errors = new ArrayList<SearchException>();
                    }
                    errors.add(e);
                }
            }
            if (!Utils.emptyCollection(errors)) {
                throw SearchMultiExceptionFactory.createException("Error occured while populating 'index added' event", errors);
            }
        }
        log.debug((Object)("Index [" + ind.getName() + "] added to search module"));
    }

    @Override
    public void removeIndex(String indexName) throws SearchException {
        Index ind = this.getIndex(indexName);
        this.removeIndex(ind);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIndex(Index index) throws SearchException {
        IndexConfigurationSingle conf;
        String path;
        Object object = this.indexesMutex;
        synchronized (object) {
            this.indexesMap.remove(index.getName());
            this.setMultiIndexesMap.values().remove(index);
        }
        ArrayList<Exception> errors = null;
        try {
            index.doIndexRemovedEvent();
        }
        catch (Exception e) {
            if (errors == null) {
                errors = new ArrayList<Exception>();
            }
            errors.add(e);
        }
        if (index.isSingle() && !Utils.emptyStr((String)(path = (conf = (IndexConfigurationSingle)index.getIndexConfiguration()).getIndexPath()))) {
            try {
                File dir = new File(path);
                if (dir.exists()) {
                    FileUtils.deleteFilesFromDirectory((File)dir);
                    if (Utils.emptyArray((Object[])dir.list())) {
                        FileUtils.deleteDir((File)dir);
                    }
                }
            }
            catch (Exception e) {
                if (errors == null) {
                    errors = new ArrayList();
                }
                errors.add(e);
            }
        }
        if (!Utils.emptyCollection((Collection)errors)) {
            throw SearchMultiExceptionFactory.createException("Removal of index '" + index.getName() + "' failed", errors);
        }
    }

    @Override
    public void setActive(String indexName, boolean active) throws SearchException {
        Index ind = this.getIndex(indexName);
        ind.setActive(false);
    }

    @Override
    public Collection<String> listIndexNames(boolean singleOnly) {
        if (!singleOnly) {
            return new ArrayList<String>((Collection)this.indexesMap.keySet());
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (Index ind : this.indexesMap.values()) {
            if (!ind.isSingle()) continue;
            ret.add(ind.getName());
        }
        return ret;
    }

    @Override
    public MultiIndex getIndexAll() {
        return this.indexAll;
    }

    public void setIndexAll(MultiIndex indexAll) {
        this.indexAll = indexAll;
    }

    @Override
    public void addModuleEventListener(ModuleEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeModuleEventListener(ModuleEventListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiIndex getMultiIndex(String indexName, IndexSelector selector, boolean allowEmpty) throws SearchException {
        Index index = this.indexesMap.get(indexName);
        if (index == null) {
            if (this.multiIndexFactory == null) {
                throw new SearchException("Creation of dynamic multi index failed - multi index factory does not exist");
            }
            Object object = this.indexesMutex;
            synchronized (object) {
                index = this.indexesMap.get(indexName);
                if (index == null) {
                    MultiIndex multiIndex = this.multiIndexFactory.createMultiIndex(indexName, selector, allowEmpty);
                    this.addIndex(multiIndex);
                    this.addModuleEventListener(multiIndex);
                    index = multiIndex;
                }
            }
        }
        if (index.isSingle()) {
            throw new SearchException("Index '" + indexName + "' is not multi-index");
        }
        return (MultiIndex)index;
    }

    @Override
    public void destroy() {
        for (Index index : this.setMultiIndexesMap.values()) {
            this.destroyIndex(index);
        }
        for (Index index : this.indexesMap.values()) {
            this.destroyIndex(index);
        }
        if (this.indexAll != null) {
            this.destroyIndex(this.indexAll);
        }
    }

    private void destroyIndex(Index index) {
        try {
            index.destroy();
        }
        catch (Exception e) {
            log.error((Object)("Error while destroying index '" + index.getName() + "'"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiIndex getSetMultiIndex(Set<String> indexNames) throws SearchException {
        MultiIndex index = this.setMultiIndexesMap.get(indexNames);
        if (index == null) {
            Object object = this.indexesMutex;
            synchronized (object) {
                index = this.setMultiIndexesMap.get(indexNames);
                if (index != null) {
                    return index;
                }
                if (this.multiIndexFactory == null) {
                    throw new SearchException("Creation of dynamic multi index failed - multi index factory does not exist");
                }
                index = this.multiIndexFactory.createMultiIndex(indexNames);
                this.setMultiIndexesMap.put(indexNames, index);
                this.addIndex(index);
            }
        }
        return index;
    }

    public void init() throws SearchException {
        if (this.filterFactory == null) {
            this.filterFactory = new FilterFactoryImpl();
        }
        for (Index ind : this.indexesMap.values()) {
            ind.init();
            ind.getSearcher().setFilterFactory(this.filterFactory);
        }
        if (this.indexAll != null) {
            this.indexAll.setSearchModule(this);
            this.addModuleEventListener(this.indexAll);
            if (Utils.emptyCollection(this.indexAll.getSubindexes())) {
                HashSet<Index> singleIndexes = new HashSet<Index>();
                for (Index index : this.indexesMap.values()) {
                    if (!index.isSingle()) continue;
                    singleIndexes.add(index);
                }
                this.indexAll.setSubindexes(singleIndexes);
            }
            this.indexAll.init();
            this.indexAll.getSearcher().setFilterFactory(this.filterFactory);
        }
    }

    public void setIndexes(Collection<? extends Index> indexes) throws SearchException {
        this.indexesMap.clear();
        for (Index index : indexes) {
            this.addIndex(index);
        }
    }

    public void setMultiIndexFactory(DynamicMultiIndexFactory multiIndexFactory) {
        this.multiIndexFactory = multiIndexFactory;
        multiIndexFactory.setSearchModule(this);
    }

    @Override
    public FilterFactory getFilterFactory() {
        return this.filterFactory;
    }

    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }
}

