/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.module.impl.lucene;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.FSDirectory;
import pl.edu.icm.yadda.common.utils.Utils;
import pl.edu.icm.yadda.service.search.SearchException;
import pl.edu.icm.yadda.service.search.errors.SearchConfigException;
import pl.edu.icm.yadda.service.search.module.config.IndexConfigurationSingle;
import pl.edu.icm.yadda.service.search.module.impl.lucene.IndexDirectoryManager;

public class IndexDirectoryManagerImpl
implements IndexDirectoryManager {
    public static final Log log = LogFactory.getLog(IndexDirectoryManagerImpl.class);
    private static final String INDEX_PATH_CONFIG_FILE = ".indexPathConfig";
    private static final String P_INDEX_PATH = "indexPath";
    private File indexRootDir;

    public File createNewIndexDirectory() throws SearchException {
        File file = new File(this.indexRootDir, "index-" + System.currentTimeMillis());
        try {
            this.initDir(file);
            this.writeIndexPathConfig(file.getAbsolutePath());
            log.info((Object)("Created new index directory [" + file.getAbsolutePath() + "]"));
            return file;
        }
        catch (Exception exception) {
            throw new SearchConfigException("Creation of new index directory failed [" + file.getAbsolutePath() + "]", exception);
        }
    }

    public void dropIndexDirectory(File file) throws SearchException {
        if (!file.exists()) {
            return;
        }
        FSDirectory fSDirectory = null;
        String string = null;
        try {
            String[] stringArray;
            fSDirectory = FSDirectory.getDirectory((File)file);
            string = fSDirectory.getLockID();
            fSDirectory.makeLock(string);
            for (String string2 : stringArray = fSDirectory.list()) {
                File file2 = new File(file, string2);
                log.debug((Object)("File to be deleted:" + file2));
                if (file2.delete()) continue;
            }
        }
        catch (Exception exception) {
            throw new SearchException("Removal of index directory failed [" + file.getAbsolutePath() + "]", (Throwable)exception);
        }
        finally {
            try {
                if (fSDirectory != null && string != null) {
                    fSDirectory.clearLock(string);
                }
            }
            catch (Exception exception) {
                log.error((Object)("Lock release failed for directory [" + file.getAbsolutePath() + "]"), (Throwable)exception);
            }
        }
    }

    public void switchCurrentIndexDirectory(File file) throws SearchException {
        this.writeIndexPathConfig(file.getAbsolutePath());
    }

    public File getCurrentIndexDirectory() throws SearchException {
        File file = new File(this.indexRootDir, INDEX_PATH_CONFIG_FILE);
        if (file.exists()) {
            try {
                Properties properties = new Properties();
                properties.load(new BufferedInputStream(new FileInputStream(file)));
                String string = properties.getProperty(P_INDEX_PATH);
                if (Utils.emptyStr((String)string)) {
                    throw new SearchConfigException("Index config file [" + file.getAbsolutePath() + "] does not contain index directory path");
                }
                File file2 = new File(string);
                if (file2.isAbsolute()) {
                    return file2;
                }
                return new File(this.indexRootDir, file2.getPath());
            }
            catch (Exception exception) {
                throw new SearchConfigException("Could not read config file [" + file.getAbsolutePath() + "]", exception);
            }
        }
        if (IndexReader.indexExists((File)this.indexRootDir)) {
            return this.indexRootDir;
        }
        return this.createNewIndexDirectory();
    }

    public void setConfiguration(IndexConfigurationSingle indexConfigurationSingle) throws SearchConfigException {
        String string = indexConfigurationSingle.getIndexPath();
        if (Utils.emptyStr((String)string)) {
            throw new SearchConfigException("Index configuration doesn't have index path");
        }
        File file = new File(string);
        this.initDir(file);
        this.indexRootDir = file;
    }

    private void initDir(File file) throws SearchConfigException {
        if (!file.exists()) {
            try {
                if (!file.mkdirs()) {
                    throw new SearchConfigException("Directory [" + file.getAbsolutePath() + "] couldn't be created");
                }
            }
            catch (SecurityException securityException) {
                throw new SearchConfigException("Error occured while creating new directory [" + file.getAbsolutePath() + "]", securityException);
            }
        }
    }

    private void writeIndexPathConfig(String string) throws SearchConfigException {
        File file = new File(this.indexRootDir, INDEX_PATH_CONFIG_FILE);
        try {
            Properties properties = new Properties();
            properties.setProperty(P_INDEX_PATH, string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            properties.store(bufferedOutputStream, "");
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (Exception exception) {
            throw new SearchConfigException("Writing index directory config file failed [" + file.getAbsolutePath() + "]");
        }
    }
}

