/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.query.xml.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Properties;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import pl.edu.icm.yadda.service.search.SearchException;
import pl.edu.icm.yadda.service.search.query.Order;
import pl.edu.icm.yadda.service.search.query.SearchCriterion;
import pl.edu.icm.yadda.service.search.query.SearchOperator;
import pl.edu.icm.yadda.service.search.query.SearchQuery;
import pl.edu.icm.yadda.service.search.query.criteria.BooleanCriterion;
import pl.edu.icm.yadda.service.search.query.criteria.FieldCriterion;
import pl.edu.icm.yadda.service.search.query.criteria.FieldPhraseCriterion;
import pl.edu.icm.yadda.service.search.query.criteria.FieldRangeCriterion;
import pl.edu.icm.yadda.service.search.query.xml.SearchQueryXMLFactory;

public class SearchQueryXMLFactoryImpl
implements SearchQueryXMLFactory,
ErrorHandler,
Serializable {
    private static final long serialVersionUID = 8861238513065835230L;
    private static final Log log = LogFactory.getLog(SearchQueryXMLFactoryImpl.class);
    private Digester digester;
    private static VelocityEngine velocityEngine;
    private static final String VM_QUERY_TEMPLATE = "pl/edu/icm/yadda/service/search/query/xml/impl/query_definition.vm";
    private static final String P_QUERY = "query";
    private static final String P_SUBQUERY = "*/subquery";
    private static final String P_FIELD = "*/crit-field";
    private static final String P_FIELD_PHRASE = "*/crit-phrase";
    private static final String P_FIELD_RANGE = "*/crit-range";
    private static final String P_BOOLEAN = "*/boolean";
    private static final String P_ORDER = "query/order";
    private static final String A_ORDER_RELEVANCE = "relevance";
    private static final String A_ORDER_FIELD = "field";
    private static final String A_ORDER_ASCENDING = "ascending";
    private static final String A_YES = "yes";
    private static final String A_OPERATOR = "operator";

    public SearchQueryXMLFactoryImpl() {
        this.configure();
    }

    public SearchQuery parseQuery(Reader reader) throws SearchException {
        try {
            return (SearchQuery)this.digester.parse(reader);
        }
        catch (Exception exception) {
            throw new SearchException("Couldn't parse xml query reader.", (Throwable)exception);
        }
    }

    public SearchQuery parseQuery(String string) throws SearchException {
        try {
            return (SearchQuery)this.digester.parse((Reader)new StringReader(string));
        }
        catch (Exception exception) {
            throw new SearchException("Couldn't parse xml query [[" + string + "]].", (Throwable)exception);
        }
    }

    public SearchQuery parseQueryFromURI(String string) throws SearchException {
        try {
            return (SearchQuery)this.digester.parse(string);
        }
        catch (Exception exception) {
            throw new SearchException("Couldn't parse xml query (uri=" + string + ").", (Throwable)exception);
        }
    }

    public String write2XML(SearchQuery searchQuery) throws SearchException {
        try {
            StringWriter stringWriter = new StringWriter();
            this.write(searchQuery, stringWriter);
            return stringWriter.toString();
        }
        catch (Exception exception) {
            throw new SearchException("Couldn't write search query XML representation as string.", (Throwable)exception);
        }
    }

    public void write2XML(SearchQuery searchQuery, File file) throws SearchException {
        try {
            BufferedWriter bufferedWriter = this.getWriter(file);
            this.write(searchQuery, bufferedWriter);
        }
        catch (Exception exception) {
            throw new SearchException("Couldn't write search query to XML (file=" + (file != null ? file.getAbsolutePath() : null) + ")", (Throwable)exception);
        }
    }

    private void write(SearchQuery searchQuery, Writer writer) throws Exception {
        Template template = SearchQueryXMLFactoryImpl.getTemplate();
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("util", (Object)this);
        velocityContext.put(P_QUERY, (Object)searchQuery);
        template.merge((Context)velocityContext, writer);
        writer.flush();
        writer.close();
    }

    private void configure() {
        this.digester = new Digester();
        URL uRL = this.getClass().getResource("bwnquery-2.0.dtd");
        this.digester.register("-//ICM//DTD BWNQUERY 2.0//EN", uRL.toString());
        this.digester.setValidating(true);
        this.digester.setErrorHandler((ErrorHandler)this);
        this.digester.addObjectCreate(P_QUERY, SearchQuery.class);
        this.digester.addSetProperties(P_QUERY, "index", "indexName");
        this.digester.addObjectCreate(P_SUBQUERY, SearchQuery.class);
        this.digester.addSetProperties(P_SUBQUERY, "index", "indexName");
        this.digester.addSetNext(P_SUBQUERY, "addSubquery");
        this.digester.addFactoryCreate(P_FIELD, (ObjectCreationFactory)new DigesterFactory(FactoryType.O_FIELD_CRIT));
        this.digester.addSetProperties(P_FIELD, A_OPERATOR, null);
        this.digester.addSetNext(P_FIELD, "addCriterion");
        this.digester.addFactoryCreate(P_FIELD_PHRASE, (ObjectCreationFactory)new DigesterFactory(FactoryType.O_PHRASE_CRIT));
        this.digester.addSetProperties(P_FIELD_PHRASE, A_OPERATOR, null);
        this.digester.addSetNext(P_FIELD_PHRASE, "addCriterion");
        this.digester.addFactoryCreate(P_FIELD_RANGE, (ObjectCreationFactory)new DigesterFactory(FactoryType.O_RANGE_CRIT));
        this.digester.addSetProperties(P_FIELD_RANGE, new String[]{"lower", "upper", A_OPERATOR}, new String[]{"from", "to", null});
        this.digester.addSetNext(P_FIELD_RANGE, "addCriterion");
        this.digester.addFactoryCreate(P_BOOLEAN, (ObjectCreationFactory)new DigesterFactory(FactoryType.O_BOOLEAN_CRIT));
        this.digester.addSetNext(P_BOOLEAN, "addCriterion");
        this.digester.addFactoryCreate(P_ORDER, (ObjectCreationFactory)new DigesterFactory(FactoryType.O_ORDER));
        this.digester.addSetProperties(P_ORDER);
        this.digester.addSetNext(P_ORDER, "addOrder");
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        log.error((Object)"Xml error.", (Throwable)sAXParseException);
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        log.error((Object)"Xml fatal error.", (Throwable)sAXParseException);
        throw sAXParseException;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        log.warn((Object)"Xml warning.", (Throwable)sAXParseException);
    }

    protected static Template getTemplate() throws SearchException {
        try {
            Template template = velocityEngine.getTemplate(VM_QUERY_TEMPLATE);
            if (template == null) {
                throw new SearchException("Search query definition template doesn't exist!");
            }
            return template;
        }
        catch (Exception exception) {
            log.error((Object)"Cannot initialize search query definition template.", (Throwable)exception);
            throw new SearchException("Cannot initialize search query definition template.", (Throwable)exception);
        }
    }

    protected BufferedWriter getWriter(File file) throws SearchException {
        try {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF-8")));
        }
        catch (Exception exception) {
            throw new SearchException("Couldn't create writer for query definition (file=" + file.getAbsolutePath() + ").", (Throwable)exception);
        }
    }

    public String escape(String string) {
        return string == null ? string : string.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;");
    }

    public boolean isPhraseCrit(SearchCriterion searchCriterion) {
        return searchCriterion.getType() == SearchCriterion.CriterionType.PHRASE;
    }

    public boolean isRangeCrit(SearchCriterion searchCriterion) {
        return searchCriterion.getType() == SearchCriterion.CriterionType.RANGE;
    }

    public boolean isBooleanCrit(SearchCriterion searchCriterion) {
        return searchCriterion.getType() == SearchCriterion.CriterionType.BOOLEAN;
    }

    static {
        try {
            velocityEngine = new VelocityEngine();
            InputStream inputStream = SearchQueryXMLFactoryImpl.class.getResourceAsStream("velocity.properties");
            Properties properties = new Properties();
            properties.load(inputStream);
            velocityEngine.init(properties);
        }
        catch (Exception exception) {
            log.error((Object)"Error initializing velocity for search query definitions.", (Throwable)exception);
            throw new RuntimeException("Error initializing velocity for search query definitions.", exception);
        }
    }

    private class DigesterFactory
    implements ObjectCreationFactory {
        private FactoryType factoryType;
        private Digester _digester;

        DigesterFactory(FactoryType factoryType) {
            this.factoryType = factoryType;
        }

        public Object createObject(Attributes attributes) throws Exception {
            FieldCriterion fieldCriterion = null;
            switch (this.factoryType) {
                case O_FIELD_CRIT: {
                    fieldCriterion = new FieldCriterion();
                    break;
                }
                case O_PHRASE_CRIT: {
                    fieldCriterion = new FieldPhraseCriterion();
                    break;
                }
                case O_RANGE_CRIT: {
                    fieldCriterion = new FieldRangeCriterion();
                    break;
                }
                case O_BOOLEAN_CRIT: {
                    fieldCriterion = new BooleanCriterion();
                    break;
                }
                case O_ORDER: {
                    return SearchQueryXMLFactoryImpl.A_YES.equals(attributes.getValue(SearchQueryXMLFactoryImpl.A_ORDER_RELEVANCE)) ? Order.relevanceOrder() : new Order(attributes.getValue(SearchQueryXMLFactoryImpl.A_ORDER_FIELD), SearchQueryXMLFactoryImpl.A_YES.equals(attributes.getValue(SearchQueryXMLFactoryImpl.A_ORDER_ASCENDING)));
                }
                default: {
                    throw new SearchException("Unknown factory type (" + (Object)((Object)this.factoryType) + ")");
                }
            }
            String string = attributes.getValue(SearchQueryXMLFactoryImpl.A_OPERATOR);
            if (string != null) {
                fieldCriterion.setOperator(SearchOperator.getOperatorWithName((String)string));
            }
            return fieldCriterion;
        }

        public Digester getDigester() {
            return this._digester;
        }

        public void setDigester(Digester digester) {
            this._digester = digester;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FactoryType {
        O_FIELD_CRIT,
        O_PHRASE_CRIT,
        O_RANGE_CRIT,
        O_BOOLEAN_CRIT,
        O_RELATION_CRIT,
        O_REL_FIELD_CRIT,
        O_ORDER;

    }
}

