/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.searching.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreRangeQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import pl.edu.icm.yadda.common.utils.Utils;
import pl.edu.icm.yadda.service.search.SearchException;
import pl.edu.icm.yadda.service.search.errors.SearchConfigException;
import pl.edu.icm.yadda.service.search.indexing.impl.LuceneUtils;
import pl.edu.icm.yadda.service.search.module.config.FieldMetadata;
import pl.edu.icm.yadda.service.search.module.config.IndexMetadata;
import pl.edu.icm.yadda.service.search.query.Order;
import pl.edu.icm.yadda.service.search.query.SearchCriterion;
import pl.edu.icm.yadda.service.search.query.SearchOperator;
import pl.edu.icm.yadda.service.search.query.SearchQuery;
import pl.edu.icm.yadda.service.search.query.criteria.BooleanCriterion;
import pl.edu.icm.yadda.service.search.query.criteria.FieldCriterion;
import pl.edu.icm.yadda.service.search.query.criteria.FieldPhraseCriterion;
import pl.edu.icm.yadda.service.search.query.criteria.FieldRangeCriterion;
import pl.edu.icm.yadda.service.search.searching.SearchParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryMapper {
    private Analyzer analyzer;
    private IndexMetadata metadata;

    public QueryMapper(IndexMetadata indexMetadata) throws SearchConfigException {
        this.metadata = indexMetadata;
        this.analyzer = indexMetadata.getAnalyzerFactory().getAnalyzer();
    }

    public Query mapQuery(SearchQuery searchQuery) throws SearchException {
        Query query = this.mapCriteria(searchQuery.getCriteria());
        BooleanQuery booleanQuery = null;
        for (SearchQuery searchQuery2 : searchQuery.getSubqueries()) {
            Query query2 = this.mapQuery(searchQuery2);
            if (query2 == null) continue;
            if (booleanQuery == null) {
                booleanQuery = new BooleanQuery();
                if (query != null) {
                    booleanQuery.add(query, BooleanClause.Occur.MUST);
                }
            }
            booleanQuery.add(query2, BooleanClause.Occur.MUST);
        }
        return booleanQuery == null ? query : booleanQuery;
    }

    public Query mapQuery(SearchCriterion searchCriterion) throws SearchException {
        return this.map(searchCriterion);
    }

    private Query mapCriteria(List<SearchCriterion> list) throws SearchException {
        if (list.isEmpty()) {
            return null;
        }
        Query query = null;
        SearchOperator searchOperator = null;
        Query query2 = null;
        for (SearchCriterion searchCriterion : list) {
            Query query3 = this.map(searchCriterion);
            if (query3 == null) continue;
            if (query == null) {
                query = query3;
                searchOperator = searchCriterion.getOperator();
                continue;
            }
            if (query2 == null) {
                query2 = new BooleanQuery();
                this.addQuery((BooleanQuery)query2, query, searchOperator);
            }
            this.addQuery((BooleanQuery)query2, query3, searchCriterion.getOperator());
        }
        return query2 != null ? query2 : query;
    }

    private void addQuery(BooleanQuery booleanQuery, Query query, SearchOperator searchOperator) {
        BooleanClause.Occur occur = null;
        switch (searchOperator) {
            case AND: {
                occur = BooleanClause.Occur.MUST;
                break;
            }
            case NOT: {
                occur = BooleanClause.Occur.MUST_NOT;
                break;
            }
            case OR: {
                occur = BooleanClause.Occur.SHOULD;
            }
        }
        booleanQuery.add(query, occur);
    }

    private Query map(SearchCriterion searchCriterion) throws SearchException {
        if (searchCriterion == null) {
            return null;
        }
        switch (searchCriterion.getType()) {
            case FIELD: {
                return this.mapFieldCriterion((FieldCriterion)searchCriterion);
            }
            case PHRASE: {
                return this.mapPhraseCriterion((FieldPhraseCriterion)searchCriterion);
            }
            case BOOLEAN: {
                return this.mapCriteria(((BooleanCriterion)searchCriterion).getCriteria());
            }
            case RANGE: {
                return this.mapRangeCriterion((FieldRangeCriterion)searchCriterion);
            }
        }
        throw new SearchException("Unknown criterion type (" + searchCriterion.getType() + ")");
    }

    private Query mapFieldCriterion(FieldCriterion fieldCriterion) throws SearchException {
        if (Utils.emptyStr((String)fieldCriterion.getValue())) {
            return null;
        }
        String string = fieldCriterion.getField();
        FieldMetadata fieldMetadata = this.metadata.getFieldMetadata(string);
        if (fieldMetadata == null) {
            throw new SearchException("Query error - unknown index field '" + string + "'");
        }
        if (!fieldMetadata.isSpan()) {
            if (fieldMetadata.getIndexed() == Field.Index.UN_TOKENIZED) {
                return new TermQuery(new Term(fieldCriterion.getField(), fieldCriterion.getValue().trim()));
            }
            return this.parseCriterion(fieldCriterion);
        }
        try {
            TokenStream tokenStream = this.analyzer.tokenStream(string, (Reader)new StringReader(fieldCriterion.getValue()));
            ArrayList<Term> arrayList = new ArrayList<Term>();
            Token token = tokenStream.next();
            while (token != null) {
                arrayList.add(new Term(string, new String(token.termBuffer(), 0, token.termLength())));
                token = tokenStream.next();
            }
            switch (arrayList.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    return new TermQuery((Term)arrayList.get(0));
                }
            }
            token = new SpanQuery[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                token[i] = new SpanTermQuery((Term)arrayList.get(i));
            }
            return new SpanNearQuery((SpanQuery[])token, fieldMetadata.getSpan(), false);
        }
        catch (IOException iOException) {
            throw new SearchException("Error while building span query.", (Throwable)iOException);
        }
    }

    private Query parseCriterion(FieldCriterion fieldCriterion) throws SearchException {
        try {
            QueryParser queryParser = new QueryParser(fieldCriterion.getField(), this.analyzer);
            QueryParser.Operator operator = fieldCriterion.getParserOperator() == SearchOperator.OR ? QueryParser.Operator.OR : QueryParser.Operator.AND;
            queryParser.setDefaultOperator(operator);
            return queryParser.parse(fieldCriterion.getValue());
        }
        catch (ParseException parseException) {
            throw new SearchParserException(fieldCriterion.getField(), fieldCriterion.getValue(), (Throwable)parseException);
        }
    }

    private Query mapPhraseCriterion(FieldPhraseCriterion fieldPhraseCriterion) throws SearchException {
        try {
            if (Utils.emptyStr((String)fieldPhraseCriterion.getValue())) {
                return null;
            }
            String string = fieldPhraseCriterion.getField();
            TokenStream tokenStream = this.analyzer.tokenStream(string, (Reader)new StringReader(fieldPhraseCriterion.getValue()));
            ArrayList<Object> arrayList = null;
            Token token = tokenStream.next();
            while (token != null) {
                Term term = new Term(string, new String(token.termBuffer(), 0, token.termLength()));
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>();
                }
                arrayList.add(term);
                token = tokenStream.next();
            }
            if (Utils.emptyCollection(arrayList)) {
                return null;
            }
            if (arrayList.size() == 1) {
                return new TermQuery((Term)arrayList.get(0));
            }
            token = new PhraseQuery();
            for (Term term : arrayList) {
                token.add(term);
            }
            return token;
        }
        catch (IOException iOException) {
            throw new SearchException("Error while building phrase query.", (Throwable)iOException);
        }
    }

    public Query mapRangeCriterion(FieldRangeCriterion fieldRangeCriterion) throws SearchException {
        if (Utils.emptyStr((String)fieldRangeCriterion.getFrom()) && Utils.emptyStr((String)fieldRangeCriterion.getTo())) {
            throw new SearchException("Both lower and upper bounds can't be empty in range query (field:" + fieldRangeCriterion.getField() + ")");
        }
        return new ConstantScoreRangeQuery(fieldRangeCriterion.getField(), fieldRangeCriterion.getFrom(), fieldRangeCriterion.getTo(), fieldRangeCriterion.isInclusive(), fieldRangeCriterion.isInclusive());
    }

    public Sort mapOrder(List<Order> list) throws SearchException {
        ArrayList<SortField> arrayList = new ArrayList<SortField>();
        for (Order order : list) {
            String string = order.getField();
            SortField sortField = null;
            if (order.isRelevance()) {
                sortField = SortField.FIELD_SCORE;
            } else {
                FieldMetadata fieldMetadata = this.metadata.getFieldMetadata(string);
                if (fieldMetadata == null) {
                    throw new SearchException("Query error - unknown index field '" + string + "' (used for sorting)");
                }
                if (!fieldMetadata.isSortable()) {
                    throw new SearchException("Query error - index field '" + string + "' is not sortable");
                }
                sortField = new SortField(LuceneUtils.getSortField(string, fieldMetadata), !order.isAscending());
            }
            arrayList.add(sortField);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        SortField[] sortFieldArray = arrayList.toArray(new SortField[arrayList.size()]);
        return new Sort(sortFieldArray);
    }
}

