/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.searching.impl;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.NullFragmenter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import pl.edu.icm.yadda.common.utils.TimerUtil;
import pl.edu.icm.yadda.common.utils.Utils;
import pl.edu.icm.yadda.service.search.SearchException;
import pl.edu.icm.yadda.service.search.errors.EmptyQueryException;
import pl.edu.icm.yadda.service.search.errors.SearchConfigException;
import pl.edu.icm.yadda.service.search.errors.TooManyClausesException;
import pl.edu.icm.yadda.service.search.filter.FilterFactory;
import pl.edu.icm.yadda.service.search.module.Index;
import pl.edu.icm.yadda.service.search.module.config.FieldMetadata;
import pl.edu.icm.yadda.service.search.module.config.IndexMetadata;
import pl.edu.icm.yadda.service.search.module.config.LuceneSearcherData;
import pl.edu.icm.yadda.service.search.query.SearchQuery;
import pl.edu.icm.yadda.service.search.query.criteria.FilterCriterion;
import pl.edu.icm.yadda.service.search.query.criteria.MatchAllCriterion;
import pl.edu.icm.yadda.service.search.searching.FieldRequest;
import pl.edu.icm.yadda.service.search.searching.HitCollectorWrapper;
import pl.edu.icm.yadda.service.search.searching.ResultField;
import pl.edu.icm.yadda.service.search.searching.ResultsFormat;
import pl.edu.icm.yadda.service.search.searching.SearchResult;
import pl.edu.icm.yadda.service.search.searching.SearchResults;
import pl.edu.icm.yadda.service.search.searching.Searcher;
import pl.edu.icm.yadda.service.search.searching.impl.QueryMapper;
import pl.edu.icm.yadda.service.search.searching.impl.UnmappedQueryWrapper;
import pl.edu.icm.yadda.service.search.searching.iterators.IteratorSession;
import pl.edu.icm.yadda.service.search.searching.iterators.IteratorSessionManager;
import pl.edu.icm.yadda.service.search.searching.iterators.SearchAllException;
import pl.edu.icm.yadda.service.search.searching.utils.SingleFieldSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearcherImpl
implements Searcher {
    private static final Log log = LogFactory.getLog(SearcherImpl.class);
    private static final int RESULTS_MAX_SIZE = 1000;
    protected IteratorSessionManager iteratorSessionManager = new IteratorSessionManager();
    protected FilterFactory filterFactory;
    protected String id;
    private Index index;

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String toString() {
        return "Searcher: " + this.id;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SearchResults search(SearchQuery searchQuery, ResultsFormat resultsFormat) throws SearchException {
        LuceneSearcherData searcher = null;
        try {
            Hits hits;
            boolean highlight;
            TimerUtil timer = null;
            if (log.isDebugEnabled()) {
                timer = new TimerUtil();
            }
            if (resultsFormat != null && !resultsFormat.returnId() && Utils.emptyCollection((Collection)resultsFormat.getFieldRequests())) {
                throw new SearchException("Wrong results format - neither id nor fields are requested");
            }
            searcher = this.getSearcherData();
            if (log.isDebugEnabled()) {
                log.debug((Object)("SearcherData obtained in " + timer.getDuration() + " ms"));
            }
            if (searcher == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Searcher '" + this.id + "' has null Lucene searcher. Returning 0 results (total time:" + timer.getTotalDuration() + ")"));
                }
                SearchResults searchResults = new SearchResults();
                this.releaseSearcherData(searcher);
                return searchResults;
            }
            boolean bl = highlight = resultsFormat != null && this.checkFieldRequests(resultsFormat.getFieldRequests(), searcher.getIndexMetadata());
            if (this.isMatchAllQuery(searchQuery)) {
                if (highlight) {
                    throw new SearchException("Match all query can not have highlighted results");
                }
                SearchResults searchResults = this.iterateAll(searchQuery, resultsFormat, searcher);
                this.releaseSearcherData(searcher);
                return searchResults;
            }
            int first = searchQuery.getFirst();
            int size = searchQuery.getSize();
            if (size <= 0) {
                size = 1000;
            }
            QueryMapper mapper = new QueryMapper(searcher.getIndexMetadata());
            Filter filter = this.getFilter(searchQuery, mapper);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Filter obtained in " + timer.getDuration() + " ms"));
            }
            Query lucQuery = mapper.mapQuery(searchQuery);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Query mapped in " + timer.getDuration() + " ms"));
            }
            if (lucQuery == null) {
                if (filter == null) {
                    throw new EmptyQueryException("Empty queries are forbidden");
                }
                log.debug((Object)("Only filter criterion is non-empty (filterName: " + searchQuery.getFilterCriterion().getName() + ")"));
                lucQuery = new MatchAllDocsQuery();
            }
            Sort sort = mapper.mapOrder(searchQuery.getOrders());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Sort request prepared in " + timer.getDuration() + " ms"));
            }
            if (highlight) {
                lucQuery = searcher.getSearcher().rewrite(lucQuery);
            }
            Hits hits2 = hits = sort != null ? searcher.getSearcher().search(lucQuery, filter, sort) : searcher.getSearcher().search(lucQuery, filter);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Lucene search time: " + timer.getDuration() + " ms"));
            }
            int hitsCount = hits == null ? 0 : hits.length();
            int afterLast = Math.min(hitsCount, first + size);
            SearchResults results = new SearchResults();
            results.setCount(hitsCount);
            results.setFirst(first);
            Highlighter highlighter = null;
            if (highlight) {
                highlighter = new Highlighter((Formatter)new SimpleHTMLFormatter("<HIGHLIGHT>", "</HIGHLIGHT>"), (Scorer)new QueryScorer(lucQuery));
                highlighter.setTextFragmenter((Fragmenter)new NullFragmenter());
            }
            int i = first;
            while (true) {
                if (i >= afterLast) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Results prepared in " + timer.getDuration() + " ms"));
                        log.debug((Object)("Total search time: " + timer.getTotalDuration() + " ms"));
                    }
                    SearchResults searchResults = results;
                    this.releaseSearcherData(searcher);
                    return searchResults;
                }
                SearchResult res = this.createResult(hits.doc(i), hits.score(i), resultsFormat, highlighter, searcher.getIndexMetadata());
                results.addResult(res);
                ++i;
            }
        }
        catch (SearchException se) {
            try {
                log.error((Object)"Search error", (Throwable)se);
                throw se;
                catch (BooleanQuery.TooManyClauses e) {
                    log.error((Object)"Search error (wildcard query problem)", (Throwable)e);
                    throw new TooManyClausesException("Wildcard query error: " + e.getMessage(), e);
                }
                catch (Exception e) {
                    log.error((Object)"Error occured during search.", (Throwable)e);
                    throw new SearchException("Error occured during search.", (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                this.releaseSearcherData(searcher);
                throw throwable;
            }
        }
    }

    @Override
    public void collect(SearchQuery searchQuery, HitCollectorWrapper hitCollectorWrapper) throws SearchException {
        LuceneSearcherData searcherData = null;
        try {
            try {
                searcherData = this.getSearcherData();
                if (searcherData == null) {
                    throw new SearchException("Null searcher when performing search with hit collector wrapper");
                }
                if (!Utils.emptyCollection((Collection)searchQuery.getOrders())) {
                    throw new SearchException("Sort is not allowed in searches with hit collector");
                }
                QueryMapper mapper = new QueryMapper(searcherData.getIndexMetadata());
                Filter filter = this.getFilter(searchQuery, mapper);
                Query lucQuery = mapper.mapQuery(searchQuery);
                if (lucQuery == null) {
                    if (filter == null) {
                        throw new EmptyQueryException("Empty queries are forbidden");
                    }
                    log.debug((Object)("Only filter criterion is non-empty (filterName: " + searchQuery.getFilterCriterion().getName() + ")"));
                    lucQuery = new MatchAllDocsQuery();
                }
                searcherData.getSearcher().search(lucQuery, filter, hitCollectorWrapper.getHitCollector());
                hitCollectorWrapper.processHits(searcherData.getSearcher());
            }
            catch (SearchException se) {
                log.error((Object)"Hit collector wrapper search error", (Throwable)se);
                throw se;
            }
            catch (BooleanQuery.TooManyClauses e) {
                log.error((Object)"Hit collector wrapper search error (wildcard query problem)", (Throwable)e);
                throw new TooManyClausesException("Wildcard query error: " + e.getMessage(), e);
            }
            catch (Exception e) {
                log.error((Object)"Error occured during hit collector wrapper search.", (Throwable)e);
                throw new SearchException("Error occured during hit collector wrapper search.", (Throwable)e);
            }
        }
        finally {
            this.releaseSearcherData(searcherData);
        }
    }

    protected Filter getFilter(SearchQuery query, QueryMapper mapper) throws SearchException {
        FilterCriterion filterCrit = query.getFilterCriterion();
        if (filterCrit != null) {
            return this.filterFactory.getFilter(filterCrit.getName(), new UnmappedQueryWrapper(filterCrit.getCriterion(), mapper));
        }
        return null;
    }

    protected SearchResults iterateAll(SearchQuery query, ResultsFormat resultsFormat, LuceneSearcherData searcher) throws SearchException {
        IteratorSession iteratorSession = null;
        int processedCount = query.getFirst();
        if (processedCount == 0) {
            iteratorSession = new IteratorSession();
            iteratorSession.setIndexVersion(searcher.getIndexVersion());
        } else {
            iteratorSession = this.iteratorSessionManager.findSession(processedCount);
            if (iteratorSession == null) {
                throw new SearchAllException("No matching iterator session for search-all request (firstDoc==" + processedCount + ")");
            }
            if (searcher.getIndexVersion() != iteratorSession.getIndexVersion()) {
                throw new SearchAllException("Index has changed since last request (iterator index version:" + iteratorSession.getIndexVersion() + ", current version:" + searcher.getIndexVersion());
            }
        }
        int nextDocId = iteratorSession.getNextLuceneId();
        int maxDoc = searcher.getMaxDoc();
        int size = query.getSize();
        SingleFieldSelector fieldSelector = null;
        if (resultsFormat != null && !resultsFormat.returnId() && resultsFormat.getFieldRequests().size() == 1) {
            FieldRequest req = (FieldRequest)resultsFormat.getFieldRequests().get(0);
            fieldSelector = new SingleFieldSelector(req.getFieldName());
        }
        SearchResults results = new SearchResults();
        results.setCount(searcher.getDocumentsNumber());
        results.setFirst(processedCount);
        IndexReader indexReader = searcher.getIndexReader();
        IndexMetadata indexConfig = searcher.getIndexMetadata();
        int count = 0;
        int i = nextDocId;
        while (i < maxDoc && count < size) {
            block10: {
                if (!indexReader.isDeleted(i)) {
                    try {
                        Document doc;
                        Document document = doc = fieldSelector == null ? indexReader.document(i) : indexReader.document(i, (FieldSelector)fieldSelector);
                        if (doc == null) break block10;
                        results.addResult(this.createResult(doc, 1.0f, resultsFormat, null, indexConfig));
                    }
                    catch (Exception e) {
                        throw new SearchException("Error while iterating through all documents in the index (current doc id:" + i + ")", (Throwable)e);
                    }
                    ++count;
                }
            }
            ++i;
        }
        if (i < maxDoc || i == maxDoc && nextDocId < maxDoc) {
            iteratorSession.setNextLuceneId(i);
            iteratorSession.setProcessedCount(processedCount + count);
            this.iteratorSessionManager.addSession(iteratorSession);
        }
        return results;
    }

    protected boolean isMatchAllQuery(SearchQuery query) throws SearchException {
        if (query.getCriteria().size() == 1 && query.getCriteria().get(0) instanceof MatchAllCriterion) {
            if (!Utils.emptyCollection((Collection)query.getOrders())) {
                throw new SearchException("Match all query can not have orders");
            }
            if (!Utils.emptyCollection((Collection)query.getSubqueries())) {
                throw new SearchException("Match all query can not have subqueries");
            }
            return true;
        }
        return false;
    }

    private LuceneSearcherData getSearcherData() throws SearchException {
        return this.index.getLuceneSearcherData();
    }

    protected void releaseSearcherData(LuceneSearcherData searcherData) {
        if (searcherData != null) {
            try {
                searcherData.release();
            }
            catch (Exception e) {
                log.error((Object)("Release of searcher data '" + searcherData.getIndexName() + "' failed"), (Throwable)e);
            }
        }
    }

    @Override
    public void init(Index index) throws SearchConfigException {
        this.index = index;
    }

    protected SearchResult createResult(Document doc, float score, ResultsFormat format, Highlighter highlighter, IndexMetadata indexMetadata) throws SearchException {
        String docId = null;
        if ((format == null || format.returnId()) && (docId = doc.get("__DOCID__")) == null) {
            throw new SearchException("Found document doesn't have id (" + doc + ")");
        }
        SearchResult res = new SearchResult(docId, score);
        if (format == null) {
            return res;
        }
        if (!Utils.emptyCollection((Collection)format.getFieldRequests())) {
            ArrayList<ResultField> fields = new ArrayList<ResultField>();
            for (FieldRequest fieldReq : format.getFieldRequests()) {
                String fieldStoreName = fieldReq.getFieldName();
                String[] values = doc.getValues(fieldStoreName);
                byte[][] binaryValues = doc.getBinaryValues(fieldStoreName);
                if (values == null && binaryValues == null) continue;
                String[] highlightedValues = null;
                if (values != null && fieldReq.isHighlighted()) {
                    highlightedValues = new String[values.length];
                    int i = 0;
                    while (i < values.length) {
                        try {
                            TokenStream tokenStream = indexMetadata.getAnalyzerFactory().getAnalyzer().tokenStream(fieldStoreName, (Reader)new StringReader(values[i]));
                            highlightedValues[i] = highlighter.getBestFragment(tokenStream, values[i]);
                        }
                        catch (Exception e) {
                            throw new SearchException("Error occured during results highlighting (field: " + fieldReq.getFieldName() + ")", (Throwable)e);
                        }
                        ++i;
                    }
                }
                fields.add(new ResultField(fieldReq.getFieldName(), values, binaryValues, highlightedValues));
            }
            res.setFields(fields);
        }
        return res;
    }

    protected boolean checkFieldRequests(List<FieldRequest> fields, IndexMetadata indexMetadata) throws SearchException {
        boolean highlight = false;
        ListIterator<FieldRequest> it = fields.listIterator();
        while (it.hasNext()) {
            FieldRequest fieldReq = it.next();
            String fieldName = fieldReq.getFieldName();
            FieldMetadata fc = indexMetadata.getFieldMetadata(fieldName);
            if (fc == null) {
                throw new SearchException("Results format error - unknown field '" + fieldName + "' (searcher id: [" + this.getId() + "])");
            }
            if (fc.getStored() == Field.Store.NO) {
                throw new SearchException("Results format error - field '" + fieldName + "' is not stored (searcher id: [" + this.getId() + "])");
            }
            if (highlight) continue;
            highlight = fieldReq.isHighlighted();
        }
        return highlight;
    }

    @Override
    public void setFilterFactory(FilterFactory filterFactory) {
        this.filterFactory = filterFactory;
    }
}

