/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.searching.stats.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TopDocCollector;
import org.apache.lucene.search.TopDocs;
import pl.edu.icm.yadda.common.utils.Utils;
import pl.edu.icm.yadda.service.search.SearchException;
import pl.edu.icm.yadda.service.search.searching.HitCollectorWrapper;
import pl.edu.icm.yadda.service.search.searching.stats.QueryStats;
import pl.edu.icm.yadda.service.search.searching.stats.impl.FieldStatsImpl;
import pl.edu.icm.yadda.service.search.searching.stats.impl.QueryStatsImpl;
import pl.edu.icm.yadda.service.search.utils.StoredFieldManager;
import pl.edu.icm.yadda.service.search.utils.impl.StoredFieldManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsHitCollectorWrapper
implements HitCollectorWrapper {
    private TopDocCollector hitCollector;
    private StoredFieldManager storedFieldManager;
    private String statsFieldName;
    private Set<String> statsUntokenizedFields;
    private Set<String> statsTokenizedFields;
    private QueryStatsImpl queryStats;

    public StatsHitCollectorWrapper(int n, String string) {
        this.statsFieldName = string;
        this.hitCollector = new TopDocCollector(n);
        this.storedFieldManager = new StoredFieldManagerImpl();
    }

    @Override
    public HitCollector getHitCollector() {
        return this.hitCollector;
    }

    @Override
    public void processHits(Searcher searcher) throws SearchException {
        try {
            HashMap<String, FieldStatsImpl> hashMap = new HashMap<String, FieldStatsImpl>();
            if (!Utils.emptyCollection(this.statsUntokenizedFields)) {
                for (String object2 : this.statsUntokenizedFields) {
                    hashMap.put(object2, new FieldStatsImpl(object2, false));
                }
            }
            if (!Utils.emptyCollection(this.statsTokenizedFields)) {
                for (String string : this.statsTokenizedFields) {
                    hashMap.put(string, new FieldStatsImpl(string, true));
                }
            }
            TopDocs topDocs = this.hitCollector.topDocs();
            ScoreDoc[] scoreDocArray = topDocs.scoreDocs;
            FieldSelectorImpl fieldSelectorImpl = new FieldSelectorImpl();
            for (int i = 0; i < scoreDocArray.length; ++i) {
                ScoreDoc scoreDoc = scoreDocArray[i];
                Document document = searcher.doc(scoreDoc.doc, (FieldSelector)fieldSelectorImpl);
                String[] stringArray = this.storedFieldManager.decodeStoredField(document, this.statsFieldName);
                if (stringArray.length % 2 != 0) {
                    throw new SearchException("Wrong results format - decoded field array for field [" + this.statsFieldName + "] has odd length");
                }
                for (int j = 0; j < stringArray.length; j += 2) {
                    String string = stringArray[j];
                    FieldStatsImpl fieldStatsImpl = (FieldStatsImpl)hashMap.get(string);
                    if (fieldStatsImpl == null) continue;
                    fieldStatsImpl.addValueOccurence(stringArray[j + 1]);
                }
            }
            this.queryStats = new QueryStatsImpl(hashMap.values());
            this.queryStats.setAnalyzedNumber(scoreDocArray.length);
            this.queryStats.setResultsNumber(topDocs.totalHits);
        }
        catch (Exception exception) {
            throw new SearchException("Processing hits for statistics failed", (Throwable)exception);
        }
    }

    public void setUntokenizedStatsFields(Set<String> set) throws SearchException {
        if (this.statsTokenizedFields != null && !Collections.disjoint(this.statsTokenizedFields, set)) {
            throw new SearchException("Tokenized and untokenized stat fields sets are not disjoint");
        }
        this.statsUntokenizedFields = set;
    }

    public void setTokenizedStatsFields(Set<String> set) throws SearchException {
        if (this.statsUntokenizedFields != null && !Collections.disjoint(this.statsUntokenizedFields, set)) {
            throw new SearchException("Tokenized and untokenized stat fields sets are not disjoint");
        }
        this.statsTokenizedFields = set;
    }

    public QueryStats getQueryStats() {
        return this.queryStats;
    }

    class FieldSelectorImpl
    implements FieldSelector {
        private static final long serialVersionUID = -4235627335854977907L;

        FieldSelectorImpl() {
        }

        public FieldSelectorResult accept(String string) {
            if (StatsHitCollectorWrapper.this.statsFieldName.equals(string)) {
                return FieldSelectorResult.LOAD_AND_BREAK;
            }
            return FieldSelectorResult.NO_LOAD;
        }
    }
}

