/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service.search.utils.impl;

import java.util.List;
import org.apache.lucene.document.Document;
import pl.edu.icm.yadda.common.utils.Utils;
import pl.edu.icm.yadda.service.search.SearchException;
import pl.edu.icm.yadda.service.search.indexing.IndexDocument;
import pl.edu.icm.yadda.service.search.searching.ResultField;
import pl.edu.icm.yadda.service.search.utils.StoredFieldManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredFieldManagerImpl
implements StoredFieldManager {
    @Override
    public void encodeStoredField(String string, List<String> list, IndexDocument indexDocument) {
        if (list != null && list.size() % 2 != 0) {
            throw new IllegalArgumentException("Fields list must have even length");
        }
        indexDocument.addField(string, Utils.serializeStringList(list));
    }

    @Override
    public String[] decodeStoredField(ResultField resultField) throws SearchException {
        String[] stringArray = resultField.getValues();
        if (stringArray == null) {
            throw new SearchException("Wrong results format - returned value of field [" + resultField.getName() + "] is null");
        }
        if (stringArray.length != 1) {
            throw new SearchException("Wrong results format - there is more than 1 value of field [" + resultField.getName() + "] (values number: " + stringArray.length + ")");
        }
        return Utils.deserializeStringArray((String)stringArray[0]);
    }

    @Override
    public String[] decodeStoredField(Document document, String string) throws SearchException {
        String[] stringArray = document.getValues(string);
        if (stringArray == null) {
            throw new SearchException("Wrong results format - returned value of field [" + string + "] is null");
        }
        if (stringArray.length != 1) {
            throw new SearchException("Wrong results format - there is more than 1 value of field [" + string + "] (values number: " + stringArray.length + ")");
        }
        return Utils.deserializeStringArray((String)stringArray[0]);
    }
}

