/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service2.search.impl;

import java.util.LinkedList;
import pl.edu.icm.yadda.service.search.SearchException;
import pl.edu.icm.yadda.service.search.errors.NoSuchIndexException;
import pl.edu.icm.yadda.service.search.indexing.IndexSession;
import pl.edu.icm.yadda.service2.GenericResponse;
import pl.edu.icm.yadda.service2.YaddaError;
import pl.edu.icm.yadda.service2.index.AccessIndexRequest;
import pl.edu.icm.yadda.service2.index.BooleanResponse;
import pl.edu.icm.yadda.service2.index.IIndexManagerService;
import pl.edu.icm.yadda.service2.index.IndexSesssionData;
import pl.edu.icm.yadda.service2.index.MarkActiveRequest;
import pl.edu.icm.yadda.service2.index.SessionAwareRequest;
import pl.edu.icm.yadda.service2.index.SessionDataResponse;
import pl.edu.icm.yadda.service2.index.SessionListResponse;
import pl.edu.icm.yadda.service2.search.impl.IndexService2Impl;

public class IndexManagerService2Impl
extends IndexService2Impl
implements IIndexManagerService {
    public SessionDataResponse fetchSessionData(SessionAwareRequest sessionAwareRequest) {
        IndexSession indexSession = (IndexSession)this.sessions.get(sessionAwareRequest.getSessionId());
        if (indexSession == null) {
            return new SessionDataResponse();
        }
        return new SessionDataResponse(this.buildSessionData(indexSession));
    }

    public SessionListResponse getActiveSessions() {
        this.expireOldSessions();
        LinkedList<IndexSesssionData> linkedList = new LinkedList<IndexSesssionData>();
        for (IndexSession indexSession : this.sessions.values()) {
            linkedList.add(this.buildSessionData(indexSession));
        }
        return new SessionListResponse(linkedList);
    }

    public BooleanResponse indexExists(AccessIndexRequest accessIndexRequest) {
        try {
            this.searchModule.getIndex(accessIndexRequest.getIndexName());
            return new BooleanResponse(true);
        }
        catch (NoSuchIndexException noSuchIndexException) {
            return new BooleanResponse(false);
        }
    }

    public GenericResponse markActive(MarkActiveRequest markActiveRequest) {
        try {
            this.searchModule.setActive(markActiveRequest.getIndexName(), markActiveRequest.isActive());
            return new GenericResponse();
        }
        catch (SearchException searchException) {
            return new GenericResponse(new YaddaError(this.ERROR_CODE, searchException.getMessage(), (Exception)((Object)searchException)));
        }
    }

    public GenericResponse optimize(AccessIndexRequest accessIndexRequest) {
        try {
            this.getIndexer(accessIndexRequest.getIndexName()).optimize();
            return new GenericResponse();
        }
        catch (SearchException searchException) {
            return new GenericResponse(new YaddaError(this.ERROR_CODE, searchException.getMessage(), (Exception)((Object)searchException)));
        }
    }

    public GenericResponse recreate(AccessIndexRequest accessIndexRequest) {
        try {
            this.getIndexer(accessIndexRequest.getIndexName()).recreate();
            return new GenericResponse();
        }
        catch (SearchException searchException) {
            return new GenericResponse(new YaddaError(this.ERROR_CODE, searchException.getMessage(), (Exception)((Object)searchException)));
        }
    }
}

