/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service2.search.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Required;
import pl.edu.icm.yadda.bean.Configurable;
import pl.edu.icm.yadda.bean.ConfigurableUtitlities;
import pl.edu.icm.yadda.bean.Problem;
import pl.edu.icm.yadda.service.search.SearchException;
import pl.edu.icm.yadda.service.search.errors.IndexNotOpenedException;
import pl.edu.icm.yadda.service.search.errors.NoSuchIndexException;
import pl.edu.icm.yadda.service.search.indexing.IndexSession;
import pl.edu.icm.yadda.service.search.indexing.Indexer;
import pl.edu.icm.yadda.service.search.module.Index;
import pl.edu.icm.yadda.service.search.module.SearchModule;
import pl.edu.icm.yadda.service2.GenericResponse;
import pl.edu.icm.yadda.service2.GetFeaturesRequest;
import pl.edu.icm.yadda.service2.GetFeaturesResponse;
import pl.edu.icm.yadda.service2.YaddaError;
import pl.edu.icm.yadda.service2.index.AddDocumentsRequest;
import pl.edu.icm.yadda.service2.index.ConnectRequest;
import pl.edu.icm.yadda.service2.index.IIndexService;
import pl.edu.icm.yadda.service2.index.IndexSesssionData;
import pl.edu.icm.yadda.service2.index.RemoveDocumentsRequest;
import pl.edu.icm.yadda.service2.index.SessionAwareRequest;
import pl.edu.icm.yadda.service2.index.SessionDataResponse;
import pl.edu.icm.yadda.service2.search.impl.SessionExpirator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexService2Impl
implements IIndexService,
SessionExpirator,
Configurable {
    protected String ERROR_CODE = "???";
    protected final Set<String> FEATURES = new HashSet<String>();
    protected SearchModule searchModule;
    protected Configurable[] configurables = new Configurable[0];
    protected Map<String, IndexSession> sessions = Collections.synchronizedMap(new HashMap());

    public SessionDataResponse connect(ConnectRequest connectRequest) {
        try {
            Indexer indexer = this.getIndexer(connectRequest.getIndexName());
            IndexSession indexSession = indexer.connect(connectRequest.getParameters());
            this.expireOldSessions();
            this.addSession(indexSession);
            return new SessionDataResponse(this.buildSessionData(indexSession));
        }
        catch (Exception exception) {
            return new SessionDataResponse(new YaddaError(this.ERROR_CODE, exception.getMessage(), exception));
        }
    }

    public GenericResponse commit(SessionAwareRequest sessionAwareRequest) {
        try {
            IndexSession indexSession = this.getSession(sessionAwareRequest);
            indexSession.commit();
            this.removeSession(indexSession.getSessionId());
            return new GenericResponse();
        }
        catch (SearchException searchException) {
            return new GenericResponse(new YaddaError(this.ERROR_CODE, searchException.getMessage(), (Exception)((Object)searchException)));
        }
    }

    public GenericResponse rollback(SessionAwareRequest sessionAwareRequest) {
        try {
            IndexSession indexSession = this.getSession(sessionAwareRequest);
            indexSession.rollback();
            return new GenericResponse();
        }
        catch (SearchException searchException) {
            return new GenericResponse(new YaddaError(this.ERROR_CODE, searchException.getMessage(), (Exception)((Object)searchException)));
        }
    }

    public GenericResponse add(AddDocumentsRequest addDocumentsRequest) {
        try {
            this.getSession((SessionAwareRequest)addDocumentsRequest).add(addDocumentsRequest.getDocs());
            return new GenericResponse();
        }
        catch (SearchException searchException) {
            return new GenericResponse(new YaddaError(this.ERROR_CODE, searchException.getMessage(), (Exception)((Object)searchException)));
        }
    }

    public GenericResponse delete(RemoveDocumentsRequest removeDocumentsRequest) {
        try {
            this.getSession((SessionAwareRequest)removeDocumentsRequest).delete(removeDocumentsRequest.getDocumentIds());
            return new GenericResponse();
        }
        catch (SearchException searchException) {
            return new GenericResponse(new YaddaError(this.ERROR_CODE, searchException.getMessage(), (Exception)((Object)searchException)));
        }
    }

    public GetFeaturesResponse getFeatures(GetFeaturesRequest getFeaturesRequest) {
        return new GetFeaturesResponse(this.FEATURES);
    }

    protected IndexSession getSession(SessionAwareRequest sessionAwareRequest) throws SearchException {
        IndexSession indexSession = this.sessions.get(sessionAwareRequest.getSessionId());
        if (indexSession == null) {
            throw new SearchException("Session with id " + sessionAwareRequest.getSessionId() + " not found");
        }
        return indexSession;
    }

    protected Index getIndex(String string) throws NoSuchIndexException {
        return this.searchModule.getIndex(string);
    }

    protected Indexer getIndexer(String string) throws NoSuchIndexException, SearchException {
        Index index = this.getIndex(string);
        Indexer indexer = index.getIndexer();
        if (indexer == null) {
            throw new SearchException("Search index '" + string + "' does not have indexer.");
        }
        return indexer;
    }

    protected void addSession(IndexSession indexSession) {
        this.sessions.put(indexSession.getSessionId(), indexSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSession(String string) {
        IndexSession indexSession;
        IndexSession indexSession2 = indexSession = this.sessions.get(string);
        synchronized (indexSession2) {
            if (indexSession != null) {
                try {
                    if (indexSession.isOpened()) {
                        indexSession.rollback();
                    }
                }
                catch (IndexNotOpenedException indexNotOpenedException) {
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
                finally {
                    this.sessions.remove(string);
                }
            }
        }
    }

    @Override
    public void expireOldSessions() {
        for (IndexSession indexSession : new LinkedList<IndexSession>(this.sessions.values())) {
            if (!indexSession.isExpired()) continue;
            this.removeSession(indexSession.getSessionId());
        }
    }

    public void expireAllSessions() {
        for (IndexSession indexSession : new LinkedList<IndexSession>(this.sessions.values())) {
            this.removeSession(indexSession.getSessionId());
        }
    }

    protected IndexSesssionData buildSessionData(IndexSession indexSession) {
        return new IndexSesssionData(indexSession.getSessionId(), indexSession.isReadOnly(), indexSession.isAutoCommit(), indexSession.getExpirationTime());
    }

    public SearchModule getSearchModule() {
        return this.searchModule;
    }

    @Required
    public void setSearchModule(SearchModule searchModule) {
        this.searchModule = searchModule;
    }

    public void destroy() throws Exception {
        ConfigurableUtitlities.destroy((Object[])this.configurables);
    }

    public Problem[] isPrepared() {
        return ConfigurableUtitlities.arePrepared((Object[])this.configurables);
    }

    public void prepare() throws Exception {
        ConfigurableUtitlities.prepare((Object[])this.configurables);
    }

    public List<Configurable> getConfigurables() {
        LinkedList<Configurable> linkedList = new LinkedList<Configurable>();
        CollectionUtils.addAll(linkedList, (Object[])this.configurables);
        return linkedList;
    }

    public void setConfigurables(List<Configurable> list) {
        this.configurables = list.toArray(new Configurable[list.size()]);
    }
}

