/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.yadda.service2.search.impl;

import com.thoughtworks.xstream.XStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pl.edu.icm.yadda.service.search.SearchException;
import pl.edu.icm.yadda.service.search.module.Index;
import pl.edu.icm.yadda.service.search.module.SearchModule;
import pl.edu.icm.yadda.service.search.query.SearchQuery;
import pl.edu.icm.yadda.service.search.searching.ResultsFormat;
import pl.edu.icm.yadda.service.search.searching.SearchResults;
import pl.edu.icm.yadda.service.search.searching.Searcher;
import pl.edu.icm.yadda.service2.GetFeaturesRequest;
import pl.edu.icm.yadda.service2.GetFeaturesResponse;
import pl.edu.icm.yadda.service2.YaddaError;
import pl.edu.icm.yadda.service2.search.ISearchService;
import pl.edu.icm.yadda.service2.search.QueryIndexesRequest;
import pl.edu.icm.yadda.service2.search.SearchRequest;
import pl.edu.icm.yadda.service2.search.SearchResponse;

public class SearchService2Impl
implements ISearchService {
    protected final Log log = LogFactory.getLog(this.getClass());
    public static final String ERROR_CODE = "Error code";
    protected final Set<String> FEATURES = new HashSet<String>();
    private SearchModule searchModule;
    private XStream serializer = new XStream();

    public SearchResponse query(QueryIndexesRequest queryIndexesRequest) {
        try {
            Index index;
            if (queryIndexesRequest.getResumptionToken() != null) {
                queryIndexesRequest = this.buildRequestFromToken(queryIndexesRequest.getResumptionToken());
            }
            if (!(index = this.searchModule.getIndex(queryIndexesRequest.getIndex())).isActive()) {
                throw new SearchException("Search index '" + queryIndexesRequest.getIndex() + "' is not active.");
            }
            Searcher searcher = index.getSearcher();
            if (searcher == null) {
                throw new SearchException("Search index '" + queryIndexesRequest.getIndex() + "' does not have searcher");
            }
            SearchResults searchResults = searcher.search(queryIndexesRequest.getQuery(), queryIndexesRequest.getResultsFormat());
            SearchQuery searchQuery = queryIndexesRequest.getQuery().clone();
            searchQuery.setFirst(searchQuery.getFirst() + searchQuery.getSize());
            String string = queryIndexesRequest.getQuery().getSize() == 0 || searchResults.getSize() == 0 ? null : this.buildToken(queryIndexesRequest.getIndex(), searchQuery, queryIndexesRequest.getResultsFormat());
            SearchResponse searchResponse = new SearchResponse(searchResults.getResults(), searchResults.getCount(), string);
            return searchResponse;
        }
        catch (Exception exception) {
            this.log.error((Object)exception.getMessage(), (Throwable)exception);
            return new SearchResponse(new YaddaError(ERROR_CODE, exception.getMessage(), exception));
        }
    }

    protected String buildToken(String string, SearchQuery searchQuery, ResultsFormat resultsFormat) {
        QueryIndexesRequest queryIndexesRequest = new QueryIndexesRequest(string, searchQuery, resultsFormat);
        return this.serializer.toXML((Object)queryIndexesRequest);
    }

    protected QueryIndexesRequest buildRequestFromToken(String string) {
        return (QueryIndexesRequest)this.serializer.fromXML(string);
    }

    public SearchResponse search(SearchRequest searchRequest) {
        return new SearchResponse(new YaddaError(ERROR_CODE, "Not implemented"));
    }

    public GetFeaturesResponse getFeatures(GetFeaturesRequest getFeaturesRequest) {
        GetFeaturesResponse getFeaturesResponse = new GetFeaturesResponse();
        getFeaturesResponse.setFeatures(new HashSet<String>(this.FEATURES));
        return getFeaturesResponse;
    }

    public SearchModule getSearchModule() {
        return this.searchModule;
    }

    public void setSearchModule(SearchModule searchModule) {
        this.searchModule = searchModule;
    }
}

