/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.resultset.push;

import eu.dnetlib.enabling.resultset.push.ResultSetDescriptor;
import eu.dnetlib.enabling.resultset.push.TransientPushResultSetDao;
import eu.dnetlib.miscutils.cache.Cache;
import eu.dnetlib.miscutils.factory.Factory;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class CacheTransientResultSetDaoImpl
implements TransientPushResultSetDao {
    private static final Log log = LogFactory.getLog(CacheTransientResultSetDaoImpl.class);
    private Cache<String, List<String>> cache;
    private Cache<String, ResultSetDescriptor> resultSetCache;
    @Resource
    private Factory<ResultSetDescriptor> resultSetDescriptorFactory;

    @Override
    public int getSize(String key) {
        ResultSetDescriptor desc = (ResultSetDescriptor)this.resultSetCache.get((Object)key);
        if (desc == null) {
            return 0;
        }
        return (desc.getRanges() - 1) * desc.getRangeLength() + ((List)this.cache.get((Object)(key + "-" + desc.getLastRange()))).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addElements(String key, List<String> elements) {
        Cache<String, List<String>> cache = this.cache;
        synchronized (cache) {
            ResultSetDescriptor desc = (ResultSetDescriptor)this.resultSetCache.get((Object)key);
            log.debug((Object)("got desc: " + desc));
            if (desc == null) {
                desc = (ResultSetDescriptor)this.resultSetDescriptorFactory.newInstance();
                this.resultSetCache.put((Object)key, (Object)desc);
            }
            log.debug((Object)("desc now is desc: " + desc));
            if (elements.size() > desc.getRangeLength()) {
                throw new IllegalArgumentException("The current implementation of the push resultset doesn't accept pages longer than " + desc.getRangeLength() + ", got: " + elements.size());
            }
            int lastRangeIndex = desc.getLastRange();
            if (lastRangeIndex < 0) {
                lastRangeIndex = 0;
            }
            log.debug((Object)("last range: " + lastRangeIndex));
            ArrayList<String> lastRange = (ArrayList<String>)this.cache.get((Object)(key + "-" + lastRangeIndex));
            log.debug((Object)("stored last range: " + lastRange));
            if (lastRange == null) {
                lastRange = new ArrayList<String>();
                desc.setRanges(desc.getRanges() + 1);
            }
            log.debug((Object)("last range is: " + lastRange));
            int free = desc.getRangeLength() - lastRange.size();
            log.debug((Object)("free: " + free));
            log.debug((Object)("desc range length: " + desc.getRangeLength()));
            log.debug((Object)("last range size: " + lastRange.size()));
            int toElements = free;
            if (toElements > elements.size()) {
                toElements = elements.size();
            } else {
                ArrayList<String> nextRange = new ArrayList<String>(elements.subList(free, elements.size()));
                log.debug((Object)("next range: " + nextRange));
                this.cache.put((Object)(key + "-" + (lastRangeIndex + 1)), nextRange);
                log.debug((Object)("next range stored at: " + key + "-" + (lastRangeIndex + 1)));
                desc.setRanges(desc.getRanges() + 1);
            }
            lastRange.addAll(elements.subList(0, toElements));
            log.debug((Object)("LAST RANGE SIZE: " + lastRange.size() + " range index " + lastRangeIndex));
            log.debug((Object)("after add: " + lastRange));
            this.cache.put((Object)(key + "-" + lastRangeIndex), lastRange);
            log.debug((Object)("range stored at: " + key + "-" + lastRangeIndex));
            this.resultSetCache.put((Object)key, (Object)desc);
        }
    }

    @Override
    public List<String> getElements(String key, int fromPosition, int toPosition) {
        ResultSetDescriptor desc = (ResultSetDescriptor)this.resultSetCache.get((Object)key);
        log.debug((Object)("got desc: " + desc));
        if (desc == null) {
            desc = (ResultSetDescriptor)this.resultSetDescriptorFactory.newInstance();
        }
        ArrayList<String> res = new ArrayList<String>();
        log.debug((Object)("ranges containing " + fromPosition + " to " + toPosition));
        for (ResultSetDescriptor.Range range : desc.getRangesContaining(fromPosition, toPosition)) {
            log.debug((Object)("reading range " + key + "-" + range.getRange() + " begin: " + range.getBegin() + " end: " + range.getEnd()));
            res.addAll(((List)this.cache.get((Object)(key + "-" + range.getRange()))).subList(range.getBegin(), range.getEnd()));
        }
        return res;
    }

    public Cache<String, List<String>> getCache() {
        return this.cache;
    }

    @Required
    public void setCache(Cache<String, List<String>> cache) {
        this.cache = cache;
    }

    public Cache<String, ResultSetDescriptor> getResultSetCache() {
        return this.resultSetCache;
    }

    @Required
    public void setResultSetCache(Cache<String, ResultSetDescriptor> resultSetCache) {
        this.resultSetCache = resultSetCache;
    }

    public Factory<ResultSetDescriptor> getResultSetDescriptorFactory() {
        return this.resultSetDescriptorFactory;
    }

    public void setResultSetDescriptorFactory(Factory<ResultSetDescriptor> resultSetDescriptorFactory) {
        this.resultSetDescriptorFactory = resultSetDescriptorFactory;
    }
}

