/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.resultset;

import eu.dnetlib.enabling.resultset.ResultSetListener;
import eu.dnetlib.enabling.resultset.rmi.ResultSetException;
import eu.dnetlib.enabling.resultset.rmi.ResultSetService;
import eu.dnetlib.enabling.tools.ServiceResolver;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CachingResultSetListener
implements ResultSetListener {
    private static final Log log = LogFactory.getLog(CachingResultSetListener.class);
    private ResultSetService service;
    private String rsId;
    private ArrayList<String> storage = new ArrayList();

    public CachingResultSetListener(W3CEndpointReference epr, ServiceResolver serviceResolver) {
        this.service = (ResultSetService)serviceResolver.getService(ResultSetService.class, epr);
        this.rsId = serviceResolver.getResourceIdentifier(epr);
    }

    @Override
    public List<String> getResult(int fromPosition, int toPosition) {
        if (this.storage.get(fromPosition) != null) {
            return this.cached(fromPosition, toPosition);
        }
        try {
            List data = this.service.getResult(this.rsId, fromPosition, toPosition, "waiting");
            this.cache(data, fromPosition, toPosition);
            return data;
        }
        catch (ResultSetException e) {
            throw new IllegalStateException(e);
        }
    }

    private void cache(List<String> data, int fromPosition, int toPosition) {
        for (String value : data) {
            this.storage.set(fromPosition++, value);
        }
    }

    private List<String> cached(int fromPosition, int toPosition) {
        log.info((Object)("found cached page " + fromPosition + ", " + toPosition));
        return this.storage.subList(fromPosition - 1, toPosition);
    }

    @Override
    public int getSize() {
        try {
            return this.service.getNumberOfElements(this.rsId);
        }
        catch (ResultSetException e) {
            throw new IllegalStateException(e);
        }
    }
}

