/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.resultset.push;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResultSetDescriptor
implements Serializable {
    private static final Log log = LogFactory.getLog(Range.class);
    private static final long serialVersionUID = 7699992350256317181L;
    private int rangeLength = 100;
    private int ranges = 0;

    public int getLastRange() {
        return this.ranges - 1;
    }

    public Iterable<Range> getRangesContaining(final int fromPosition, final int toPosition) {
        final int fromRange = (fromPosition - 1) / this.rangeLength;
        int ttoRange = (int)Math.ceil((double)toPosition * 1.0 / (double)this.rangeLength);
        if (ttoRange > this.ranges) {
            ttoRange = this.ranges;
        }
        final int toRange = ttoRange;
        log.debug((Object)("FROM range: " + fromRange));
        log.debug((Object)("TTO range: " + ttoRange));
        log.debug((Object)("TO range: " + toRange));
        return new Iterable<Range>(){

            @Override
            public Iterator<Range> iterator() {
                return new Iterator<Range>(){
                    int current;
                    {
                        this.current = fromRange;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.current < toRange;
                    }

                    @Override
                    public Range next() {
                        int begin = 0;
                        int end = ResultSetDescriptor.this.rangeLength;
                        if (this.current == fromRange) {
                            begin = (fromPosition - 1) % ResultSetDescriptor.this.rangeLength;
                        }
                        if (this.current + 1 == toRange) {
                            end = (toPosition - 1) % ResultSetDescriptor.this.rangeLength + 1;
                        }
                        return new Range(this.current++, begin, end);
                    }

                    @Override
                    public void remove() {
                        throw new IllegalStateException("text");
                    }
                };
            }
        };
    }

    public int getRangeLength() {
        return this.rangeLength;
    }

    public void setRangeLength(int rangeLength) {
        this.rangeLength = rangeLength;
    }

    public int getRanges() {
        return this.ranges;
    }

    public void setRanges(int ranges) {
        this.ranges = ranges;
    }

    public class Range {
        private int range;
        private int begin;
        private int end;

        public Range(int range, int begin, int end) {
            this.range = range;
            this.begin = begin;
            this.end = end;
        }

        public String toString() {
            return "Range(" + this.range + ", " + this.begin + ", " + this.end + ")";
        }

        public int getRange() {
            return this.range;
        }

        public void setRange(int range) {
            this.range = range;
        }

        public int getBegin() {
            return this.begin;
        }

        public void setBegin(int begin) {
            this.begin = begin;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }
    }
}

