/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.espas.dm.local;

import com.google.gson.Gson;
import eu.dnetlib.espas.dm.local.GsonUtils;
import eu.dnetlib.espas.dm.local.LocalDownloadManager;
import eu.dnetlib.espas.dm.local.ResultDescriptor;
import eu.dnetlib.espas.dm.local.impl.RequestInfo;
import eu.dnetlib.espas.dm.local.impl.RequestInfoDAO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class DownloadManagerController {
    private static Logger logger = Logger.getLogger(DownloadManagerController.class);
    private LocalDownloadManager manager = null;
    private RequestInfoDAO requestInfoDAO;

    @RequestMapping(value={"/download"})
    public void download(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String descriptors = request.getParameter("descriptors");
            System.out.println(descriptors);
            int ttl = Integer.parseInt(request.getParameter("timeToLive"));
            Gson gson = GsonUtils.createGson();
            List descriptorList = (List)gson.fromJson(descriptors, List.class);
            ArrayList<ResultDescriptor> list = new ArrayList<ResultDescriptor>();
            for (Object o : descriptorList) {
                list.add((ResultDescriptor)gson.fromJson(o.toString(), ResultDescriptor.class));
            }
            response.setContentType("application/json");
            response.getOutputStream().write(GsonUtils.createGson().toJson((Object)this.manager.download(null, list, ttl, null)).getBytes());
        }
        catch (Exception e) {
            logger.error((Object)"Error starting download", (Throwable)e);
            e.printStackTrace(new PrintStream((OutputStream)response.getOutputStream()));
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"/getStatus"})
    public void getStatus(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            int requestId = Integer.parseInt(request.getParameter("requestId"));
            Gson gson = GsonUtils.createGson();
            response.setContentType("application/json");
            response.getOutputStream().write(gson.toJson((Object)this.manager.getStatus(requestId)).getBytes());
        }
        catch (Exception e) {
            logger.error((Object)"Error getting status", (Throwable)e);
            e.printStackTrace(new PrintStream((OutputStream)response.getOutputStream()));
            response.setStatus(500);
        }
    }

    @RequestMapping(value={"/getBundle"})
    public void getBundle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int requestId = Integer.parseInt(request.getParameter("requestId"));
        RequestInfo requestInfo = this.requestInfoDAO.getRequestInfoById(requestId);
        try {
            response.setContentType("application/octet-stream");
            logger.debug((Object)("Filename = " + requestInfo.getFilename()));
            response.setHeader("Content-Disposition", "attachment; filename=" + requestInfo.getFilename() + ".zip");
            IOUtils.copy((InputStream)this.manager.getBundle(requestId), (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            logger.error((Object)"Error getting bundle", (Throwable)e);
            e.printStackTrace(new PrintStream((OutputStream)response.getOutputStream()));
            response.setStatus(500);
        }
    }

    public LocalDownloadManager getManager() {
        return this.manager;
    }

    public void setManager(LocalDownloadManager manager) {
        this.manager = manager;
    }

    public void setRequestInfoDAO(RequestInfoDAO requestInfoDAO) {
        this.requestInfoDAO = requestInfoDAO;
    }
}

