/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.espas.dm.local;

import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;

public class ResultDescriptor {
    private String url;
    private Date fromDate;
    private Date toDate;
    private Integer resolution;
    private String localfilenameSuffix = null;
    private Date date;
    private String downloadJobId;

    public ResultDescriptor() {
    }

    public ResultDescriptor(String url, String localfilenameSuffix) {
        this.url = url;
        this.localfilenameSuffix = localfilenameSuffix;
    }

    public ResultDescriptor(String url, String localfilenameSuffix, Date date) {
        this.url = url;
        this.localfilenameSuffix = localfilenameSuffix;
        this.date = date;
    }

    public ResultDescriptor(String url, String localfilenameSuffix, Date fromDate, Date toDate) {
        this.url = url;
        this.localfilenameSuffix = localfilenameSuffix;
        this.fromDate = fromDate;
        this.toDate = toDate;
    }

    public ResultDescriptor(String url, String localfilenameSuffix, Date fromDate, Date toDate, int resolution) {
        this.url = url;
        this.localfilenameSuffix = localfilenameSuffix;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.resolution = resolution;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public Integer getResolution() {
        return this.resolution;
    }

    public void setResolution(Integer resolution) {
        this.resolution = resolution;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getLocalfilenameSuffix() {
        return this.localfilenameSuffix;
    }

    public void setLocalfilenameSuffix(String localfilenameSuffix) {
        this.localfilenameSuffix = localfilenameSuffix;
    }

    public String getDownloadJobId() {
        return this.downloadJobId;
    }

    public void setDownloadJobId(String downloadJobId) {
        this.downloadJobId = downloadJobId;
    }

    public String toString() {
        String outcome = this.url;
        if (this.date != null || this.fromDate != null || this.toDate != null || this.resolution != null) {
            outcome = outcome + "?";
            if (this.date != null) {
                outcome = outcome + "date=" + this.date.toString() + "&";
            }
            if (this.fromDate != null) {
                outcome = outcome + "fromDate=" + this.fromDate.toString() + "&";
            }
            if (this.toDate != null) {
                outcome = outcome + "toDate=" + this.toDate.toString() + "&";
            }
            if (this.resolution != null) {
                outcome = outcome + "resolution=" + this.resolution.toString() + "&";
            }
            outcome = outcome.substring(0, outcome.length() - 1);
        }
        return outcome;
    }

    public static String getRequestId(ResultDescriptor descriptor) {
        String descRepresentation = descriptor.url;
        DateFormat dateTimeFormater = DateFormat.getDateTimeInstance();
        dateTimeFormater.setTimeZone(TimeZone.getTimeZone("GMT"));
        if (descriptor.date != null || descriptor.fromDate != null || descriptor.toDate != null || descriptor.resolution != null) {
            descRepresentation = descRepresentation + "?";
            if (descriptor.date != null) {
                descRepresentation = descRepresentation + "date=" + dateTimeFormater.format(descriptor.date) + "&";
            }
            if (descriptor.fromDate != null) {
                descRepresentation = descRepresentation + "fromDate=" + dateTimeFormater.format(descriptor.fromDate) + "&";
            }
            if (descriptor.toDate != null) {
                descRepresentation = descRepresentation + "toDate=" + dateTimeFormater.format(descriptor.toDate) + "&";
            }
            if (descriptor.resolution != null) {
                descRepresentation = descRepresentation + "resolution=" + descriptor.resolution.toString() + "&";
            }
            descRepresentation = descRepresentation.substring(0, descRepresentation.length() - 1);
        }
        return "ReqK" + descRepresentation.hashCode();
    }
}

