/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.espas.dm.local.impl;

import eu.dnetlib.espas.dm.local.DownloadManagerException;
import eu.dnetlib.espas.dm.local.DownloadStatus;
import eu.dnetlib.espas.dm.local.LocalDownloadManager;
import eu.dnetlib.espas.dm.local.ResultDescriptor;
import eu.dnetlib.espas.dm.local.StatusListener;
import eu.dnetlib.espas.dm.local.impl.RequestInfo;
import eu.dnetlib.espas.dm.local.impl.RequestInfoDAO;
import eu.dnetlib.espas.dm.local.impl.RequestTask;
import eu.dnetlib.espas.dm.local.impl.ResultSegmentInfo;
import eu.dnetlib.espas.dm.local.impl.ResultSegmentInfoDAO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.springframework.beans.factory.annotation.Required;

public class LocalDownloadManagerImpl
implements LocalDownloadManager {
    private RequestInfoDAO requestInfoDAO;
    private ResultSegmentInfoDAO resultSegmentInfoDAO;
    private String path;
    private String dataproviderName;
    private int delay;
    private static Logger logger = Logger.getLogger(LocalDownloadManagerImpl.class);
    private ExecutorService executor = Executors.newFixedThreadPool(1);

    public void init() {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        new File(this.path, "archives").mkdirs();
        new File(this.path, "requests").mkdirs();
        List<RequestInfo> runningRequests = this.requestInfoDAO.getRequestsByStatus(DownloadStatus.Status.RUNNING);
        for (RequestInfo ri : runningRequests) {
            this.executor.execute(new RequestTask(ri.getRequestId(), this.requestInfoDAO, this.resultSegmentInfoDAO, this.path, this.delay));
        }
        List<RequestInfo> pendingRequests = this.requestInfoDAO.getRequestsByStatus(DownloadStatus.Status.PENDING);
        for (RequestInfo ri : pendingRequests) {
            this.executor.execute(new RequestTask(ri.getRequestId(), this.requestInfoDAO, this.resultSegmentInfoDAO, this.path, this.delay));
        }
    }

    @Override
    public int download(String context, List<ResultDescriptor> descriptors, int timeToLive, StatusListener statusListener) {
        ArrayList<ResultSegmentInfo> resultSegments = new ArrayList<ResultSegmentInfo>();
        LinkedList<String> resultDescriptorRequestIds = new LinkedList<String>();
        for (ResultDescriptor rd : descriptors) {
            try {
                List<ResultSegmentInfo> tempSegmentList = this.resolveResultDescriptor(rd);
                for (ResultSegmentInfo segment : tempSegmentList) {
                    resultDescriptorRequestIds.add(ResultDescriptor.getRequestId(rd));
                }
                resultSegments.addAll(tempSegmentList);
            }
            catch (MalformedURLException e) {
                logger.warn((Object)"Malformed URL exception", (Throwable)e);
            }
        }
        RequestInfo requestInfo = new RequestInfo(context, timeToLive, null, DownloadStatus.Status.PENDING, null, resultSegments, null, statusListener);
        String fileName = this.dataproviderName + "-" + new DateTime((Object)new Date()).toString(DateTimeFormat.forPattern((String)"yyyyMMdd-HHmmss"));
        requestInfo.setFilename(fileName);
        int requestId = this.requestInfoDAO.insertRequestInfo(requestInfo);
        File file = new File(new File(this.path, "requests"), fileName);
        file.mkdirs();
        requestInfo.setPath(file.getAbsolutePath());
        this.requestInfoDAO.updateRequestInfo(requestInfo);
        for (ResultSegmentInfo rsi : resultSegments) {
            rsi.setRequest(requestInfo);
            this.resultSegmentInfoDAO.insertResultSegmentInfo(rsi);
        }
        HashMap<Integer, String> resultSegmentResultDescriptorMap = new HashMap<Integer, String>();
        for (int i = 0; i < resultSegments.size(); ++i) {
            resultSegmentResultDescriptorMap.put(((ResultSegmentInfo)resultSegments.get(i)).getResultSegmentId(), (String)resultDescriptorRequestIds.get(i));
        }
        if (statusListener != null) {
            statusListener.statusChanged(new DownloadStatus(requestId, null, "", DownloadStatus.Status.PENDING));
        }
        this.executor.execute(new RequestTask(resultSegmentResultDescriptorMap, requestInfo, this.requestInfoDAO, this.resultSegmentInfoDAO, this.path, this.delay));
        return requestId;
    }

    @Override
    public DownloadStatus getStatus(int requestId) {
        RequestInfo requestInfo = this.requestInfoDAO.getRequestInfoById(requestId);
        DownloadStatus downloadStatus = new DownloadStatus(requestInfo.getRequestId(), requestInfo.getExpirationDate(), requestInfo.getMessage(), requestInfo.getStatus());
        return downloadStatus;
    }

    @Override
    public InputStream getBundle(int requestId) throws DownloadManagerException, FileNotFoundException {
        RequestInfo requestInfo = this.requestInfoDAO.getRequestInfoById(requestId);
        if (requestInfo != null) {
            return new FileInputStream(new File(requestInfo.getArchivePath()));
        }
        throw new DownloadManagerException("Request not found!");
    }

    private List<ResultSegmentInfo> resolveResultDescriptor(ResultDescriptor resultDescriptor) throws MalformedURLException {
        ArrayList<ResultSegmentInfo> resultSegments = new ArrayList<ResultSegmentInfo>();
        Pattern datePattern = Pattern.compile("\\{\\s*(exactDate|fromDate|toDate)\\s*(:\\s*format\\s*=\\s*\"([^\"]+)\")*\\s*\\}");
        Matcher dateMatcher = datePattern.matcher(resultDescriptor.getUrl());
        StringBuffer newURLString = new StringBuffer();
        Date date = null;
        Date exactDate = null;
        Date fromDate = null;
        Date toDate = null;
        while (dateMatcher.find()) {
            if (dateMatcher.group(1).equals("exactDate")) {
                exactDate = date = resultDescriptor.getDate();
            } else if (dateMatcher.group(1).equals("fromDate")) {
                fromDate = date = resultDescriptor.getFromDate();
            } else if (dateMatcher.group(1).equals("toDate")) {
                toDate = date = resultDescriptor.getToDate();
            }
            if (dateMatcher.group(2) != null) {
                System.out.println(dateMatcher.group(3));
                String newString = new SimpleDateFormat(dateMatcher.group(3)).format(date);
                dateMatcher.appendReplacement(newURLString, newString);
                continue;
            }
            dateMatcher.appendReplacement(newURLString, new DateTime(date.getTime()).toString(DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss'Z'")));
        }
        dateMatcher.appendTail(newURLString);
        ResultSegmentInfo resultSegmentInfo = new ResultSegmentInfo(newURLString.toString(), "", DownloadStatus.Status.PENDING, null);
        if (exactDate != null) {
            resultSegmentInfo.setLocalFilename(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(exactDate) + "-" + resultDescriptor.getLocalfilenameSuffix());
        } else {
            StringBuffer filename = new StringBuffer();
            if (fromDate != null) {
                filename.append(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(fromDate));
            }
            if (toDate != null) {
                if (fromDate != null) {
                    filename.append("-");
                }
                filename.append(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(fromDate));
            }
            filename.append("-");
            filename.append(resultDescriptor.getLocalfilenameSuffix());
            resultSegmentInfo.setLocalFilename(filename.toString());
        }
        resultSegments.add(resultSegmentInfo);
        return resultSegments;
    }

    @Required
    public void setRequestInfoDAO(RequestInfoDAO requestInfoDAO) {
        this.requestInfoDAO = requestInfoDAO;
    }

    @Required
    public void setResultSegmentInfoDAO(ResultSegmentInfoDAO resultSegmentInfoDAO) {
        this.resultSegmentInfoDAO = resultSegmentInfoDAO;
    }

    @Required
    public void setPath(String path) {
        this.path = path;
    }

    @Required
    public void setDataproviderName(String dataproviderName) {
        this.dataproviderName = dataproviderName;
    }

    @Required
    public void setDelay(int delay) {
        this.delay = delay;
    }

    public RequestInfoDAO getRequestInfoDAO() {
        return this.requestInfoDAO;
    }

    public ResultSegmentInfoDAO getResultSegmentInfoDAO() {
        return this.resultSegmentInfoDAO;
    }

    public String getPath() {
        return this.path;
    }

    public int getDelay() {
        return this.delay;
    }
}

