/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.espas.dm.local.impl;

import eu.dnetlib.espas.dm.local.DownloadStatus;
import eu.dnetlib.espas.dm.local.impl.RequestInfo;
import eu.dnetlib.espas.dm.local.impl.RequestInfoDAO;
import eu.dnetlib.espas.dm.local.impl.ResultSegmentInfo;
import java.io.Serializable;
import java.util.List;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RequestInfoDAOImpl
implements RequestInfoDAO {
    private SessionFactory sessionFactory;

    @Override
    public int insertRequestInfo(RequestInfo requestInfo) {
        return (Integer)this.sessionFactory.getCurrentSession().save((Object)requestInfo);
    }

    @Override
    public RequestInfo getRequestInfoById(int requestId) {
        return (RequestInfo)this.sessionFactory.getCurrentSession().get(RequestInfo.class, (Serializable)Integer.valueOf(requestId));
    }

    @Override
    public void updateRequestInfo(RequestInfo requestInfo) {
        this.sessionFactory.getCurrentSession().update((Object)requestInfo);
    }

    @Override
    public List<ResultSegmentInfo> getResultSegmentsByRequestId(int requestId) {
        return this.sessionFactory.getCurrentSession().createCriteria(ResultSegmentInfo.class).add((Criterion)Restrictions.eq((String)"request.requestId", (Object)requestId)).list();
    }

    @Override
    public List<ResultSegmentInfo> getPendingResultSegmentsByRequestId(int requestId) {
        return this.sessionFactory.getCurrentSession().createCriteria(ResultSegmentInfo.class).add((Criterion)Restrictions.eq((String)"request.requestId", (Object)requestId)).add((Criterion)Restrictions.eq((String)"status", (Object)((Object)DownloadStatus.Status.PENDING))).list();
    }

    @Override
    public List<RequestInfo> getRequestsByStatus(DownloadStatus.Status status) {
        return this.sessionFactory.getCurrentSession().createCriteria(RequestInfo.class).add((Criterion)Restrictions.eq((String)"status", (Object)((Object)status))).list();
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

