/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.espas.dm.local.impl;

import eu.dnetlib.espas.dm.local.DownloadManagerException;
import eu.dnetlib.espas.dm.local.DownloadStatus;
import eu.dnetlib.espas.dm.local.StatusListener;
import eu.dnetlib.espas.dm.local.impl.RequestInfo;
import eu.dnetlib.espas.dm.local.impl.RequestInfoDAO;
import eu.dnetlib.espas.dm.local.impl.ResultSegmentInfo;
import eu.dnetlib.espas.dm.local.impl.ResultSegmentInfoDAO;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;

public class RequestTask
implements Runnable {
    private int requestId;
    private RequestInfoDAO requestInfoDAO;
    private ResultSegmentInfoDAO resultSegmentInfoDAO;
    private Map<Integer, String> resultSegmentResultDescriptorMap;
    private String path;
    private long delay;
    private static Logger logger = Logger.getLogger(RequestTask.class);
    private RequestInfo requestInfo = null;
    private StatusListener statusListener = null;

    public RequestTask() {
    }

    public RequestTask(RequestInfoDAO requestInfoDAO, ResultSegmentInfoDAO resultSegmentInfoDAO, String path, long delay) {
        this.requestInfoDAO = requestInfoDAO;
        this.resultSegmentInfoDAO = resultSegmentInfoDAO;
        this.path = path;
        this.delay = delay;
    }

    public RequestTask(int requestId, RequestInfoDAO requestInfoDAO, ResultSegmentInfoDAO resultSegmentInfoDAO, String path, long delay) {
        this(requestInfoDAO, resultSegmentInfoDAO, path, delay);
        this.requestId = requestId;
        this.requestInfo = requestInfoDAO.getRequestInfoById(requestId);
    }

    public RequestTask(Map<Integer, String> resultSegmentResultDescriptorMap, RequestInfo requestInfo, RequestInfoDAO requestInfoDAO, ResultSegmentInfoDAO resultSegmentInfoDAO, String path, long delay) {
        this(requestInfoDAO, resultSegmentInfoDAO, path, delay);
        this.requestId = requestInfo.getRequestId();
        this.requestInfo = requestInfo;
        this.statusListener = requestInfo.getStatusListener();
        this.resultSegmentResultDescriptorMap = resultSegmentResultDescriptorMap;
    }

    @Override
    public void run() {
        this.downloadRequest();
    }

    private void downloadRequest() {
        block10: {
            if (!this.requestInfo.getStatus().equals((Object)DownloadStatus.Status.RUNNING)) {
                this.requestInfo.setStatus(DownloadStatus.Status.RUNNING);
                this.requestInfoDAO.updateRequestInfo(this.requestInfo);
                if (this.statusListener != null) {
                    this.statusListener.statusChanged(new DownloadStatus(this.requestId, null, null, DownloadStatus.Status.RUNNING));
                }
            }
            String requestDirectory = this.requestInfo.getPath();
            List<ResultSegmentInfo> pendingResultSegments = this.requestInfoDAO.getPendingResultSegmentsByRequestId(this.requestId);
            for (ResultSegmentInfo rsi : pendingResultSegments) {
                DownloadStatus status;
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException e) {
                    logger.warn((Object)("Error at sleep" + e.getMessage()));
                }
                try {
                    status = new DownloadStatus(-1, null, null, DownloadStatus.Status.RUNNING);
                    status.setResultId(this.resultSegmentResultDescriptorMap.get(rsi.getResultSegmentId()));
                    this.statusListener.requestFileStatusChanged(status);
                    this.downloadURL(rsi, requestDirectory);
                    rsi.setStatus(DownloadStatus.Status.COMPLETED);
                    this.resultSegmentInfoDAO.updateResultSegmentInfo(rsi);
                    status = new DownloadStatus(-1, null, null, DownloadStatus.Status.COMPLETED);
                    status.setResultId(this.resultSegmentResultDescriptorMap.get(rsi.getResultSegmentId()));
                    this.statusListener.requestFileStatusChanged(status);
                }
                catch (IOException e) {
                    logger.warn((Object)"IOException", (Throwable)e);
                    rsi.setStatus(DownloadStatus.Status.FAILED);
                    rsi.setMessage("IOException -- " + e.getMessage());
                    this.resultSegmentInfoDAO.updateResultSegmentInfo(rsi);
                    status = new DownloadStatus(-1, null, e.getMessage(), DownloadStatus.Status.FAILED);
                    status.setResultId(this.resultSegmentResultDescriptorMap.get(rsi.getResultSegmentId()));
                    this.statusListener.requestFileStatusChanged(status);
                }
            }
            try {
                this.requestInfo.setArchivePath(this.createBundle(this.requestInfo.getFilename()));
            }
            catch (DownloadManagerException e) {
                logger.error((Object)"Error creating bundle", (Throwable)e);
                if (this.statusListener == null) break block10;
                this.statusListener.statusChanged(new DownloadStatus(this.requestId, null, e.getMessage(), DownloadStatus.Status.FAILED));
            }
        }
        this.requestInfo.setStatus(DownloadStatus.Status.COMPLETED);
        this.requestInfo.setExpirationDate(DateUtils.addSeconds((Date)new Date(), (int)this.requestInfo.getTimeToLive()));
        this.requestInfoDAO.updateRequestInfo(this.requestInfo);
        if (this.statusListener != null) {
            this.statusListener.statusChanged(new DownloadStatus(this.requestId, this.requestInfo.getExpirationDate(), null, DownloadStatus.Status.COMPLETED));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadURL(ResultSegmentInfo rsi, String dirPath) throws IOException {
        block7: {
            BufferedOutputStream outputStream = null;
            InputStream inputStream = null;
            URLConnection urlConnection = null;
            File file = null;
            try {
                HttpURLConnection con;
                String disposition;
                URL url = new URL(rsi.getUrl());
                urlConnection = url.openConnection();
                String providerFilename = null;
                if (urlConnection instanceof HttpURLConnection && (disposition = (con = (HttpURLConnection)urlConnection).getHeaderField("Content-Disposition")) != null && disposition.contains("filename=")) {
                    disposition = disposition.trim();
                    providerFilename = disposition.substring(disposition.lastIndexOf("filename=") + 9).trim();
                }
                file = new File(dirPath, this.getFileName(url, rsi.getLocalFilename(), providerFilename));
                outputStream = new BufferedOutputStream(new FileOutputStream(file.getAbsolutePath()));
                inputStream = urlConnection.getInputStream();
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
            catch (IOException e) {
                if (file != null && file.exists()) {
                    file.delete();
                }
                break block7;
            }
            finally {
                IOUtils.closeQuietly(outputStream);
                IOUtils.closeQuietly(inputStream);
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private String getFileName(URL url, String localFilename, String providerFilename) {
        if (providerFilename != null) {
            return providerFilename;
        }
        if (localFilename != null) {
            return localFilename;
        }
        String[] splittedURL = url.toString().split("/");
        return splittedURL[splittedURL.length - 1];
    }

    private String createBundle(String fileName) throws DownloadManagerException {
        try {
            File newBundle = new File(new File(this.path, "archives"), fileName + ".zip");
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(newBundle.getAbsolutePath()));
            File directoryToZip = new File(new File(this.path, "requests"), fileName);
            this.zipDirectory(directoryToZip, zipOutputStream, directoryToZip.getParent());
            zipOutputStream.close();
            return newBundle.getAbsolutePath();
        }
        catch (IOException e) {
            throw new DownloadManagerException(e);
        }
    }

    private void zipDirectory(File directoryToZip, ZipOutputStream zipOutputStream, String directoryToZipParent) throws IOException {
        String[] dirList = directoryToZip.list();
        System.out.println(directoryToZip.getAbsolutePath());
        System.out.println(dirList.length);
        for (int i = 0; i < dirList.length; ++i) {
            File file = new File(directoryToZip, dirList[i]);
            if (file.isDirectory()) {
                this.zipDirectory(file.getAbsoluteFile(), zipOutputStream, directoryToZipParent);
                continue;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            ZipEntry zipEntry = new ZipEntry(file.getPath().replaceFirst(directoryToZipParent + File.separatorChar, ""));
            zipOutputStream.putNextEntry(zipEntry);
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)zipOutputStream);
            fileInputStream.close();
        }
    }

    public void setRequestInfoDAO(RequestInfoDAO requestInfoDAO) {
        this.requestInfoDAO = requestInfoDAO;
    }

    public void setResultSegmentInfoDAO(ResultSegmentInfoDAO resultSegmentInfoDAO) {
        this.resultSegmentInfoDAO = resultSegmentInfoDAO;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setRequestId(int requestId) {
        this.requestId = requestId;
    }
}

