/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.espas.dm.local.service;

import eu.dnetlib.enabling.tools.blackboard.ActionStatus;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardNotificationHandler;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import eu.dnetlib.espas.dm.local.DownloadStatus;
import eu.dnetlib.espas.dm.local.LocalDownloadManager;
import eu.dnetlib.espas.dm.local.ResultDescriptor;
import eu.dnetlib.espas.dm.local.StatusListener;
import eu.dnetlib.espas.dm.local.impl.RequestInfoDAO;
import eu.dnetlib.espas.dm.local.service.DownloadDBUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.log4j.Logger;

public class BlackboardListener
extends BlackboardNotificationHandler<BlackboardServerHandler> {
    private static Logger logger = Logger.getLogger(BlackboardListener.class);
    private DownloadDBUtils downloadDBUtils;
    private LocalDownloadManager manager = null;
    private RequestInfoDAO requestInfoDAO = null;
    private int timeToLive = 0;
    private String servletPath = null;

    protected void processJob(BlackboardJob job) {
        super.processJob(job);
        try {
            this.manager.download(null, this.getDescriptors(job), this.timeToLive, new Listener(job));
        }
        catch (Exception e) {
            logger.error((Object)"Error getting request", (Throwable)e);
            ((BlackboardServerHandler)this.getBlackboardHandler()).failed(job, (Throwable)e);
        }
    }

    private List<ResultDescriptor> getDescriptors(BlackboardJob job) throws JAXBException {
        String downloadJobId = (String)job.getParameters().get("downloadJob");
        String providerId = (String)job.getParameters().get("providerJob");
        logger.trace((Object)(" JobID is: " + downloadJobId + " and provider id is :" + providerId));
        List<ResultDescriptor> res = this.getRequest(downloadJobId, providerId);
        return res;
    }

    private List<ResultDescriptor> getRequest(String jobId, String providerId) throws JAXBException {
        ArrayList<ResultDescriptor> res = new ArrayList<ResultDescriptor>();
        for (Object[] requestDetails : this.downloadDBUtils.getProviderRequestDetails(jobId, providerId)) {
            ResultDescriptor resultDes = new ResultDescriptor();
            resultDes.setDownloadJobId(jobId);
            resultDes.setUrl(requestDetails[0].toString());
            if (requestDetails[1] != null) {
                try {
                    resultDes.setFromDate((Date)requestDetails[1]);
                }
                catch (Exception ex) {
                    logger.error(null, (Throwable)ex);
                }
            }
            if (requestDetails[2] != null) {
                try {
                    resultDes.setToDate((Date)requestDetails[2]);
                }
                catch (Exception ex) {
                    logger.error(null, (Throwable)ex);
                }
            }
            if (requestDetails[3] != null) {
                try {
                    resultDes.setDate((Date)requestDetails[3]);
                }
                catch (Exception ex) {
                    logger.error(null, (Throwable)ex);
                }
            }
            if (requestDetails[4] != null && !((String)requestDetails[4]).isEmpty()) {
                resultDes.setLocalfilenameSuffix(requestDetails[4].toString());
            }
            if (requestDetails[5] != null && !((String)requestDetails[5]).isEmpty()) {
                try {
                    resultDes.setResolution(Integer.parseInt(requestDetails[5].toString()));
                }
                catch (Exception ex) {
                    logger.error(null, (Throwable)ex);
                }
            }
            res.add(resultDes);
        }
        return res;
    }

    public LocalDownloadManager getManager() {
        return this.manager;
    }

    public void setManager(LocalDownloadManager manager) {
        this.manager = manager;
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public RequestInfoDAO getRequestInfoDAO() {
        return this.requestInfoDAO;
    }

    public void setRequestInfoDAO(RequestInfoDAO requestInfoDAO) {
        this.requestInfoDAO = requestInfoDAO;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public DownloadDBUtils getDownloadDBUtils() {
        return this.downloadDBUtils;
    }

    public void setDownloadDBUtils(DownloadDBUtils downloadDBUtils) {
        this.downloadDBUtils = downloadDBUtils;
    }

    class Listener
    implements StatusListener {
        private BlackboardJob job = null;
        private Logger logger = Logger.getLogger(Listener.class);

        public Listener(BlackboardJob job) {
            this.job = job;
        }

        @Override
        public void statusChanged(DownloadStatus status) {
            String downloadJobId = (String)this.job.getParameters().get("downloadJob");
            String providerId = (String)this.job.getParameters().get("providerJob");
            this.logger.debug((Object)("Setting job status to " + status.getStatus().toString()));
            BlackboardListener.this.downloadDBUtils.setDownloadJobStatus(downloadJobId, providerId, status.getStatus(), status.getMessage(), status.getStatus() == DownloadStatus.Status.COMPLETED ? BlackboardListener.this.servletPath + "/dm/getBundle?requestId=" + status.getRequestId() : "", status.getStatus() == DownloadStatus.Status.COMPLETED ? BlackboardListener.this.downloadDBUtils.getExpirationDate() : null);
            switch (status.getStatus()) {
                case COMPLETED: {
                    this.job.setActionStatus(ActionStatus.DONE);
                    this.job.getParameters().put("localRequestStatus", status.getStatus().toString());
                    this.job.getParameters().put("localRequestDownloadUrl", BlackboardListener.this.servletPath + "/dm/getBundle?requestId=" + status.getRequestId());
                    ((BlackboardServerHandler)BlackboardListener.this.getBlackboardHandler()).done(this.job);
                    break;
                }
                case FAILED: {
                    this.job.setError(status.getMessage());
                    this.job.setActionStatus(ActionStatus.FAILED);
                    this.job.getParameters().put("localRequestStatus", status.getStatus().toString());
                    ((BlackboardServerHandler)BlackboardListener.this.getBlackboardHandler()).failed(this.job, (Throwable)new Exception(status.getMessage()));
                    break;
                }
                case PENDING: {
                    this.job.getParameters().put("localRequestStatus", status.getStatus().toString());
                    this.job.setActionStatus(ActionStatus.ASSIGNED);
                    break;
                }
                case RUNNING: {
                    this.job.setActionStatus(ActionStatus.ONGOING);
                    this.job.getParameters().put("localRequestId", status.getRequestId() + "");
                    this.job.getParameters().put("localRequestStatus", status.getStatus().toString());
                    ((BlackboardServerHandler)BlackboardListener.this.getBlackboardHandler()).ongoing(this.job);
                    break;
                }
                default: {
                    this.logger.warn((Object)("Unkonwn status! " + status.getStatus().toString()));
                }
            }
        }

        @Override
        public void requestFileStatusChanged(DownloadStatus status) {
            this.logger.debug((Object)("Setting request [" + status.getResultId() + "] status to " + status.getStatus().toString()));
            String downloadJobId = (String)this.job.getParameters().get("downloadJob");
            String providerId = (String)this.job.getParameters().get("providerJob");
            BlackboardListener.this.downloadDBUtils.setDownloadRequestStatus(downloadJobId, providerId, status.getResultId(), status.getStatus(), status.getMessage());
        }
    }
}

