/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.espas.dm.local.service;

import eu.dnetlib.espas.dm.local.DownloadStatus;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class DownloadDBUtils {
    private Connection downloadDBConnection;
    private String downloadDBURL;
    private String downloadDBUser;
    private String downloadDBPass;
    private int expirationOffsetType = 6;
    private int expirationOffsetValue = 30;
    private boolean inited = false;
    private String getProviderDetailsQ = "select status, jobstatusreport, lastupdatedon,expirationdate,downloadurl from download.providerjob where providerid=? and jobid=?";
    private String getProviderRequestDetailsQ = "select url,fromdate,todate,exactdate,filenamesuffix,resolution from download.request where status!='FAILED' and providerid=? and jobid=?";
    private String setProviderStatusQ = "update download.providerjob set status=?, jobstatusreport=?, downloadurl=?, expirationdate=?, lastupdateon=? where providerid=? and jobid=?";
    private String setProviderRequestStatusQ = "update download.request set status=?,statusreport=? where providerid=? and jobid=? and requestid=?";
    private PreparedStatement getProviderDetailsStm;
    private PreparedStatement getProviderRequestDetailsStm;
    private PreparedStatement setProviderStatusStm;
    private PreparedStatement setProviderRequestStatusStm;
    private static final Logger _logger = Logger.getLogger(DownloadDBUtils.class);

    public DownloadDBUtils() throws ClassNotFoundException {
        Class.forName("org.postgresql.Driver");
    }

    private void initDB() throws SQLException {
        if (!this.inited || this.downloadDBConnection == null || this.downloadDBConnection.isClosed()) {
            this.downloadDBConnection = DriverManager.getConnection(this.downloadDBURL, this.downloadDBUser, this.downloadDBPass);
            this.getProviderDetailsStm = this.downloadDBConnection.prepareStatement(this.getProviderDetailsQ);
            this.getProviderRequestDetailsStm = this.downloadDBConnection.prepareStatement(this.getProviderRequestDetailsQ);
            this.setProviderStatusStm = this.downloadDBConnection.prepareStatement(this.setProviderStatusQ);
            this.setProviderRequestStatusStm = this.downloadDBConnection.prepareStatement(this.setProviderRequestStatusQ);
            this.inited = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Object[]> getProviderRequestDetails(String jobId, String providerId) {
        LinkedList<Object[]> results = new LinkedList<Object[]>();
        try {
            this.initDB();
            this.getProviderRequestDetailsStm.clearParameters();
            this.getProviderRequestDetailsStm.setString(1, providerId);
            this.getProviderRequestDetailsStm.setString(2, jobId);
            ResultSet providerDetailsRS = this.getProviderRequestDetailsStm.executeQuery();
            while (providerDetailsRS.next()) {
                results.add(new Object[]{providerDetailsRS.getString(1), providerDetailsRS.getTimestamp(2) != null ? new Date(providerDetailsRS.getTimestamp(2).getTime()) : null, providerDetailsRS.getTimestamp(3) != null ? new Date(providerDetailsRS.getTimestamp(3).getTime()) : null, providerDetailsRS.getTimestamp(4) != null ? new Date(providerDetailsRS.getTimestamp(4).getTime()) : null, providerDetailsRS.getString(5), providerDetailsRS.getString(6)});
            }
        }
        catch (Exception ex) {
            _logger.error(null, (Throwable)ex);
        }
        finally {
            return results;
        }
    }

    public void setDownloadRequestStatus(String downloadJobId, String providerId, String resultId, DownloadStatus.Status status, String message) {
        try {
            this.initDB();
            this.setProviderRequestStatusStm.clearParameters();
            this.setProviderRequestStatusStm.setString(1, status.name());
            this.setProviderRequestStatusStm.setString(2, message);
            this.setProviderRequestStatusStm.setString(3, providerId);
            this.setProviderRequestStatusStm.setString(4, downloadJobId);
            this.setProviderRequestStatusStm.setString(5, resultId);
            this.setProviderRequestStatusStm.executeUpdate();
        }
        catch (Exception ex) {
            _logger.error(null, (Throwable)ex);
        }
    }

    public void setDownloadJobStatus(String downloadJobId, String providerId, DownloadStatus.Status status, String message, String url, Date expirationDate) {
        try {
            this.initDB();
            _logger.debug((Object)(" Updating status for job " + (downloadJobId == null ? "null" : downloadJobId) + " provider :" + (providerId == null ? "null" : providerId) + " status :" + (status == null ? "null" : status) + " message " + (message == null ? "null" : message) + " url " + (url == null ? "null" : url) + " and date :" + (expirationDate == null ? "null" : expirationDate.toString())));
            this.setProviderStatusStm.clearParameters();
            this.setProviderStatusStm.setString(1, status.name());
            this.setProviderStatusStm.setString(2, message);
            this.setProviderStatusStm.setString(3, url == null ? "" : url);
            this.setProviderStatusStm.setTimestamp(4, new Timestamp(this.getExpirationDate().getTime()));
            this.setProviderStatusStm.setTimestamp(5, new Timestamp(new Date().getTime()));
            this.setProviderStatusStm.setString(6, providerId);
            this.setProviderStatusStm.setString(7, downloadJobId);
            this.setProviderStatusStm.executeUpdate();
        }
        catch (Exception ex) {
            _logger.error(null, (Throwable)ex);
        }
    }

    public Date getExpirationDate() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(new Date());
        ((Calendar)calendar).add(this.expirationOffsetType, this.expirationOffsetValue);
        return calendar.getTime();
    }

    public int getExpirationOffsetType() {
        return this.expirationOffsetType;
    }

    public void setExpirationOffsetType(int expirationOffsetType) {
        this.expirationOffsetType = expirationOffsetType;
    }

    public int getExpirationOffsetValue() {
        return this.expirationOffsetValue;
    }

    public void setExpirationOffsetValue(int expirationOffsetValue) {
        this.expirationOffsetValue = expirationOffsetValue;
    }

    public String getDownloadDBURL() {
        return this.downloadDBURL;
    }

    public void setDownloadDBURL(String downloadDBURL) {
        this.downloadDBURL = downloadDBURL;
    }

    public String getDownloadDBUser() {
        return this.downloadDBUser;
    }

    public void setDownloadDBUser(String downloadDBUser) {
        this.downloadDBUser = downloadDBUser;
    }

    public String getDownloadDBPass() {
        return this.downloadDBPass;
    }

    public void setDownloadDBPass(String downloadDBPass) {
        this.downloadDBPass = downloadDBPass;
    }
}

