/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.core;

import com.sun.xml.messaging.saaj.util.Base64;
import eu.dnetlib.data.index.IndexServiceException;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherException;
import eu.dnetlib.data.information.oai.publisher.core.AbstractOAICore;
import eu.dnetlib.data.information.oai.publisher.info.ListDocumentsInfo;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.info.RecordInfo;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import eu.dnetlib.data.information.oai.publisher.sets.PredefinedSetCollection;
import eu.dnetlib.data.information.oai.publisher.sets.UserDefinedSetCollection;
import eu.dnetlib.data.information.oai.publisher.stubs.DataProvider;
import eu.dnetlib.data.information.oai.publisher.stubs.DataProviderFactory;
import eu.dnetlib.data.information.oai.publisher.stubs.ISLookUpClient;
import eu.dnetlib.data.information.oai.publisher.stubs.IndexStubFactory;
import eu.dnetlib.data.information.oai.publisher.utils.EPRUtil;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class DriverOAICore
extends AbstractOAICore {
    private ISLookUpClient lookupClient;
    private IndexStubFactory indexStubFactory;
    private DataProviderFactory dataProviderFactory;
    private UserDefinedSetCollection userDefinedSetCollection;
    private PredefinedSetCollection predefinedSetCollection;
    private static final int RES_TOK_MD_PREFIX_POS = 4;
    private static final int RES_TOK_SERVICE_POS = 3;
    private static final int MIN_RES_TOK_LEN = 5;
    private static final Log log = LogFactory.getLog(DriverOAICore.class);

    public IndexStubFactory getIndexStubFactory() {
        return this.indexStubFactory;
    }

    @Required
    public void setIndexStubFactory(IndexStubFactory indexStubFactory) {
        this.indexStubFactory = indexStubFactory;
    }

    public DataProviderFactory getDataProviderFactory() {
        return this.dataProviderFactory;
    }

    @Required
    public void setDataProviderFactory(DataProviderFactory dataProviderFactory) {
        this.dataProviderFactory = dataProviderFactory;
    }

    public UserDefinedSetCollection getUserDefinedSetCollection() {
        return this.userDefinedSetCollection;
    }

    @Required
    public void setUserDefinedSetCollection(UserDefinedSetCollection userDefinedSetCollection) {
        this.userDefinedSetCollection = userDefinedSetCollection;
    }

    @Required
    public void setPredefinedSetCollection(PredefinedSetCollection predefinedSetCollection) {
        this.predefinedSetCollection = predefinedSetCollection;
    }

    public PredefinedSetCollection getPredefinedSetCollection() {
        return this.predefinedSetCollection;
    }

    protected String getXMLRecordById(MDFInfo mdf, String setspec, String id) throws OaiPublisherException {
        String driverId = setspec == null || setspec.isEmpty() ? id : setspec + "_" + new String(Base64.encode((byte[])"RepositoryServiceResources/RepositoryServiceResourceType".getBytes())) + "::" + id;
        try {
            return this.indexStubFactory.createIndexStub(mdf).getRecordById(driverId, this.dataProviderFactory);
        }
        catch (IndexServiceException e) {
            throw new OaiPublisherException("Error invoking index", (Throwable)e);
        }
    }

    public List<SetInfo> listSets() throws OaiPublisherException {
        try {
            ArrayList<SetInfo> sets = new ArrayList<SetInfo>();
            sets.addAll(this.lookupClient.listRepositories());
            sets.addAll(this.predefinedSetCollection.getAllSets());
            sets.addAll(this.userDefinedSetCollection.getAllSets());
            return sets;
        }
        catch (ISLookUpException e) {
            throw new OaiPublisherException("Error executing listSets", (Throwable)e);
        }
    }

    public List<MDFInfo> listMetadataFormats() throws OaiPublisherException {
        try {
            return this.lookupClient.listMetadataFormats();
        }
        catch (ISLookUpException e) {
            throw new OaiPublisherException("Error invoking lookup", (Throwable)e);
        }
        catch (DocumentException e) {
            throw new OaiPublisherException("Error in metadata formats xml profile", (Throwable)e);
        }
    }

    protected String getValueOfIndexedDate(Document doc, MDFInfo mdf) throws OaiPublisherException {
        String value = "2008-01-01T12:00:00Z";
        try {
            String xpath = this.lookupClient.getXpathOfIndexedDate(mdf);
            if (xpath != null && !xpath.isEmpty()) {
                value = doc.valueOf(xpath);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error valuating xpath of indexed date: " + e.getMessage()));
            log.debug((Object)e);
        }
        return value;
    }

    protected List<RecordInfo> manageResultset(boolean onlyIdentifiers, DataProvider dataProvider, int cursor, MDFInfo mdf) {
        ArrayList<RecordInfo> documents = new ArrayList<RecordInfo>();
        SAXReader reader = new SAXReader();
        try {
            List<String> list = dataProvider.getElements(cursor + 1, cursor + this.pageSize);
            for (String xml : list) {
                try {
                    String repId;
                    String[] repIdSplitted;
                    Document doc = reader.read((Reader)new StringReader(xml));
                    String identifier = doc.valueOf("//header/child::*[name()='dri:objIdentifier']/.");
                    String setspec = "";
                    if (identifier.contains("::")) {
                        String tmp = identifier.substring(0, identifier.indexOf("::"));
                        String oaiId = identifier.substring((tmp + "::").length());
                        setspec = tmp.substring(0, tmp.indexOf("_"));
                        identifier = setspec + "/" + oaiId;
                    }
                    if (setspec.isEmpty() && (repIdSplitted = (repId = doc.valueOf("//header/child::*[name()='dri:repositoryId']/.")).split("_")).length != 0) {
                        setspec = repIdSplitted[0];
                    }
                    String datestamp = this.getValueOfIndexedDate(doc, mdf);
                    RecordInfo record = new RecordInfo();
                    record.setIdentifier(identifier);
                    record.setDatestamp(datestamp);
                    record.setSetspec(setspec);
                    if (!onlyIdentifiers) {
                        String metadata = this.formatMetadataResponse((Element)doc.selectSingleNode("/record/result/metadata"), mdf);
                        record.setMetadata(metadata);
                    }
                    documents.add(record);
                }
                catch (Exception e) {
                    log.error((Object)("Error in xml record " + e.getMessage()));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
        return documents;
    }

    protected ListDocumentsInfo getDocuments(boolean onlyIdentifiers, String set, String metadataPrefix, String from, String until) throws OaiPublisherException {
        try {
            ListDocumentsInfo res = new ListDocumentsInfo();
            MDFInfo mdf = this.obtainMDFInfo(metadataPrefix);
            String query = "";
            if (set != null) {
                query = query + this.obtainQuerySet(set);
            }
            if (from != null && until != null) {
                if (query.length() > 0) {
                    query = query + " AND ";
                }
                query = query + mdf.getIndexDate() + " within \"" + from + " " + until + "\"";
            } else if (from != null) {
                if (query.length() > 0) {
                    query = query + " AND ";
                }
                query = query + mdf.getIndexDate() + " within \"" + from + " 2099-01-01\"";
            } else if (until != null) {
                if (query.length() > 0) {
                    query = query + " AND ";
                }
                query = query + mdf.getIndexDate() + " within \"1970-01-01 " + until + "\"";
            }
            W3CEndpointReference epr = query.length() > 0 ? this.indexStubFactory.createIndexStub(mdf).searchByQuery(query) : this.indexStubFactory.createIndexStub(mdf).searchDefault();
            DataProvider dataProvider = this.dataProviderFactory.createDataProvider(epr);
            res.setnMaxElements(dataProvider.getSize());
            if (res.getnMaxElements() <= 0) {
                throw new OaiPublisherException("noRecordsMatch");
            }
            res.setDocs(this.manageResultset(onlyIdentifiers, dataProvider, 0, mdf));
            if (res.getDocs() == null || res.getDocs().isEmpty()) {
                throw new OaiPublisherException("noRecordsMatch: 'documents' is null or empty");
            }
            String resumptionToken = "";
            int cursor = 0;
            if (res.getnMaxElements() > this.pageSize) {
                resumptionToken = new String(Base64.encode((byte[])EPRUtil.getResourceIdentifier((W3CEndpointReference)epr).getBytes())) + "." + (cursor + this.pageSize) + "." + res.getnMaxElements() + "." + new String(Base64.encode((byte[])EPRUtil.getAddress((W3CEndpointReference)epr).getBytes())) + "." + new String(Base64.encode((byte[])metadataPrefix.getBytes()));
            }
            res.setResumptionToken(resumptionToken);
            return res;
        }
        catch (Exception e) {
            throw new OaiPublisherException((Throwable)e);
        }
    }

    protected ListDocumentsInfo getDocuments(boolean onlyIdentifiers, String resumptionToken) throws OaiPublisherException {
        ListDocumentsInfo res = new ListDocumentsInfo();
        String[] arr = resumptionToken.split("\\.");
        if (arr.length != 5) {
            throw new OaiPublisherException("badResumptionToken");
        }
        String rsID = Base64.base64Decode((String)arr[0]);
        res.setCursor(Integer.parseInt(arr[1]));
        res.setnMaxElements(Integer.parseInt(arr[2]));
        String serviceAddress = Base64.base64Decode((String)arr[3]);
        res.setMetadataPrefix(Base64.base64Decode((String)arr[4]));
        log.info((Object)"Resumption Token:");
        log.info((Object)("  - rsID: " + rsID));
        log.info((Object)("  - cursor: " + res.getCursor()));
        log.info((Object)("  - nMaxElements: " + res.getnMaxElements()));
        log.info((Object)("  - serviceAddress: " + serviceAddress));
        log.info((Object)("  - metadataPrefix: " + res.getMetadataPrefix()));
        DataProvider dataProvider = this.dataProviderFactory.createDataProvider(serviceAddress, rsID);
        log.info((Object)("Obtained data provider: " + dataProvider));
        MDFInfo mdf = this.obtainMDFInfo(res.getMetadataPrefix());
        res.setDocs(this.manageResultset(onlyIdentifiers, dataProvider, res.getCursor(), mdf));
        if (res.getnMaxElements() > res.getCursor() + this.pageSize) {
            res.setResumptionToken(new String(Base64.encode((byte[])rsID.getBytes())) + "." + (res.getCursor() + this.pageSize) + "." + res.getnMaxElements() + "." + new String(Base64.encode((byte[])serviceAddress.getBytes())) + "." + new String(Base64.encode((byte[])res.getMetadataPrefix().getBytes())));
        }
        return res;
    }

    private String obtainQuerySet(String set) {
        String query = "(repositoryId exact \"" + set + "_UmVwb3NpdG9yeVNlcnZpY2VSZXNvdXJjZXMvUmVwb3NpdG9yeVNlcnZpY2VSZXNvdXJjZVR5cGU=\")";
        if (this.predefinedSetCollection.containSet(set)) {
            query = this.predefinedSetCollection.getSetQuery(set);
        } else if (this.userDefinedSetCollection.containSet(set)) {
            query = this.userDefinedSetCollection.getSetQuery(set);
        }
        return query;
    }

    protected void addOrUpdateSet(SetInfo set, int ttl) {
        this.userDefinedSetCollection.addOrUpdateSet(set, ttl);
    }

    @Required
    public void setLookupClient(ISLookUpClient lookupClient) {
        this.lookupClient = lookupClient;
    }
}

