/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.stubs;

import eu.dnetlib.data.index.IIndexService;
import eu.dnetlib.data.index.IndexServiceException;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherException;
import eu.dnetlib.data.information.oai.publisher.stubs.DataProvider;
import eu.dnetlib.data.information.oai.publisher.stubs.DataProviderFactory;
import eu.dnetlib.data.information.oai.publisher.stubs.IndexStub;
import eu.dnetlib.enabling.tools.ServiceLocator;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

public class IndexStubImpl
implements IndexStub {
    private final IIndexService stub;
    private String layout;
    private String metadataFormat;
    private String defaultQuery;

    public IndexStubImpl(ServiceLocator<IIndexService> locator, String metadataFormat, String layout, String defaultQuery) {
        this.stub = (IIndexService)locator.getService();
        this.metadataFormat = metadataFormat;
        this.layout = layout;
        this.defaultQuery = defaultQuery;
    }

    @Override
    public String getRecordById(String recordId, DataProviderFactory factory) throws IndexServiceException, OaiPublisherException {
        W3CEndpointReference epr = this.stub.indexLookup("all", "objIdentifier exact \"" + recordId + "\"", this.metadataFormat, this.layout);
        DataProvider dataProvider = factory.createDataProvider(epr);
        int size = dataProvider.getSize();
        if (size != 1) {
            throw new OaiPublisherException("Invalid recordId: Index has returned " + size + " elements");
        }
        return dataProvider.getElements(1, 1).get(0);
    }

    @Override
    public W3CEndpointReference searchByQuery(String query) throws IndexServiceException {
        return this.stub.indexLookup("all", this.defaultQuery + " AND " + query, this.metadataFormat, this.layout);
    }

    @Override
    public W3CEndpointReference searchDefault() throws IndexServiceException {
        return this.stub.indexLookup("all", this.defaultQuery, this.metadataFormat, this.layout);
    }
}

