/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.stubs;

import eu.dnetlib.data.information.oai.publisher.OaiPublisherException;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Required;

public class ISLookUpClient {
    private ServiceLocator<ISLookUpService> lookupLocator;
    private final Map<String, String> mapIndexDateXPATH = new HashMap<String, String>();
    private static final Log log = LogFactory.getLog(ISLookUpClient.class);

    public List<MDFInfo> listMetadataFormats() throws ISLookUpException, DocumentException, OaiPublisherException {
        String response = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery("for $x in collection('/db/DRIVER/VocabularyDSResources/MetadataFormatDSResourceType') where $x//RESOURCE_TYPE[@value='MetadataFormatDSResourceType'] return $x");
        if (response == null || response.equals("")) {
            throw new OaiPublisherException("noMetadataFormats");
        }
        SAXReader reader = new SAXReader();
        Document document = reader.read((Reader)new StringReader(response));
        ArrayList<MDFInfo> formats = new ArrayList<MDFInfo>();
        List nodes = document.selectNodes("//METADATAFORMAT[not(@Exportable) or @Exportable ='true']");
        for (int i = 0; i < nodes.size(); ++i) {
            Element node = (Element)nodes.get(i);
            MDFInfo md = new MDFInfo();
            md.setPrefix(node.valueOf("@Prefix"));
            md.setSchema(node.valueOf("@Schema"));
            md.setNamespace(node.valueOf("@NameSpace"));
            md.setIndexPrefix(node.valueOf("@IndexPrefix"));
            md.setIndexLayout(node.valueOf("@IndexLayout"));
            md.setIndexQuery(node.valueOf("@IndexQuery"));
            md.setIndexDate(node.valueOf("@IndexDate"));
            formats.add(md);
        }
        return formats;
    }

    public List<SetInfo> listRepositories() throws ISLookUpException {
        String xQuery = "for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType') return concat($x//RESOURCE_IDENTIFIER/@value/string(),'|-$-|',$x//OFFICIAL_NAME/string(),'|-$-|',$x//ENGLISH_NAME/string())";
        ArrayList<SetInfo> response = new ArrayList<SetInfo>();
        for (String item : ((ISLookUpService)this.lookupLocator.getService()).quickSearchProfile("for $x in collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType') return concat($x//RESOURCE_IDENTIFIER/@value/string(),'|-$-|',$x//OFFICIAL_NAME/string(),'|-$-|',$x//ENGLISH_NAME/string())")) {
            String repoId = item.substring(0, item.indexOf("|-$-|"));
            item = item.substring((repoId + "|-$-|").length());
            if (repoId.equals("")) continue;
            String repoName = item.substring(0, item.indexOf("|-$-|"));
            if (repoName.equals("")) {
                repoName = item.substring("|-$-|".length());
            }
            if (repoName.equals("")) continue;
            SetInfo set = new SetInfo();
            set.setSetSpec(repoId.substring(0, repoId.indexOf("_")));
            set.setSetName(repoName);
            response.add(set);
        }
        return response;
    }

    public String getXpathOfIndexedDate(MDFInfo mdf) {
        String prefix = mdf.getIndexPrefix();
        String layout = mdf.getIndexLayout();
        String date = mdf.getIndexDate();
        String mapKey = prefix + "|" + layout + "|" + date;
        if (this.mapIndexDateXPATH.containsKey(mapKey)) {
            return this.mapIndexDateXPATH.get(mapKey);
        }
        String query = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='MDFormatDSResourceType' and .//NAME='" + prefix + "']//LAYOUT[@name = '" + layout + "']//FIELD[@name='" + date + "']/@xpath/string()";
        log.info((Object)("Executing xquery to found xpath: " + query));
        String xpath = null;
        try {
            xpath = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(query);
        }
        catch (Exception e) {
            log.error((Object)"XPATH not found");
        }
        this.mapIndexDateXPATH.put(mapKey, xpath);
        return xpath;
    }

    @Required
    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }
}

