package eu.dnetlib.data.information.oai.publisher.conf;

import java.util.Iterator;
import java.util.List;

import javax.annotation.Resource;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;

import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.tools.SplittedQueryExecutor;

public class PublisherConfigurationReader {

	/**
	 * Constant names of fields used by the publisher to store records in the OAIStores. If you want an index over them, you need to specify
	 * it in the OAI Publisher Configuration profile.
	 */
	public final static String ID_FIELD = "objIdentifier";
	public final static String DATESTAMP_FIELD = "datestamp";
	public final static String SET_FIELD = "set";
	public final static String DELETED_FIELD = "deleted";
	public final static String BODY_FIELD = "body";
	public final static String UPDATED_FIELD = "updated";
	public final static String LAST_COLLECTION_DATE_FIELD = "lastCollectionDate";

	/**
	 * Used to generate the OAI identifiers compliant to the protocol. See
	 * http://www.openarchives.org/OAI/openarchivesprotocol.html#UniqueIdentifier. See property services.oai.publisher.id.scheme.
	 */
	private String idScheme;
	/**
	 * Used to generate the OAI identifiers compliant to the protocol. See
	 * http://www.openarchives.org/OAI/openarchivesprotocol.html#UniqueIdentifier. See property services.oai.publisher.id.namespace.
	 */
	private String idNamespace;

	@Resource
	private SplittedQueryExecutor queryExecutor;

	public List<SetInfo> getSets() {
		final String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION/OAISETS/OAISET "
				+ "return concat($x/spec, ':-:', $x/name, ':-:', $x//description , ':-:', $x//query, ':-:', $x/@enabled/string())";
		Iterable<SetInfo> sets = this.queryExecutor.query(SetInfo.class, query, ":-:");
		return Lists.newArrayList(sets);
	}

	public List<SetInfo> getSets(final boolean onlyEnabled) {
		if (onlyEnabled) {
			final String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION/OAISETS/OAISET "
					+ "where $x/@enabled/string() = 'true' "
					+ "return concat($x/spec, ':-:', $x/name, ':-:', $x//description , ':-:', $x//query, ':-:', $x/@enabled/string())";
			Iterable<SetInfo> sets = this.queryExecutor.query(SetInfo.class, query, ":-:");
			return Lists.newArrayList(sets);
		} else return this.getSets();
	}

	public List<String> getSetSpecs() {
		final String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION/OAISETS/OAISET "
				+ "where $x/@enabled/string() = 'true' " + "return $x/spec/string() ";
		List<String> names = this.queryExecutor.performQuery(query);
		return names;
	}

	public SetInfo getSetInfo(final String setSpec) {
		final String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION/OAISETS/OAISET "
				+ "where $x/spec = '"
				+ setSpec
				+ "' "
				+ "return concat($x/spec, ':-:', $x/name, ':-:', $x//description , ':-:', $x//query, ':-:', $x/@enabled/string())";
		Iterable<SetInfo> sets = this.queryExecutor.query(SetInfo.class, query, ":-:");
		if (sets.iterator().hasNext()) return sets.iterator().next();
		else return null;
	}

	public List<MDFInfo> getMetadataFormatInfo() {
		final String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION//METADATAFORMAT "
				+ "return concat($x/@metadataPrefix/string(), ':-:', $x//SCHEMA , ':-:', $x//NAMESPACE,  "
				+ "':-:', $x//SOURCE_METADATA_FORMAT/@name/string(), ':-:',  $x//SOURCE_METADATA_FORMAT/@layout/string(), ':-:', $x//SOURCE_METADATA_FORMAT/@interpretation/string(), "
				+ "':-:', $x//BASE_QUERY, ':-:',  $x//TRANSFORMATION_RULE, ':-:', $x/@exportable/string() )";
		Iterable<MDFInfo> mdFormats = this.queryExecutor.query(MDFInfo.class, query, ":-:");
		return Lists.newArrayList(mdFormats);
	}

	public List<MDFInfo> getMetadataFormatInfo(final boolean onlyEnabled) {
		if (onlyEnabled) {
			final String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION//METADATAFORMAT "
					+ "where $x/@exportable/string() = 'true' "
					+ "return concat($x/@metadataPrefix/string(), ':-:', $x//SCHEMA , ':-:', $x//NAMESPACE,  "
					+ "':-:', $x//SOURCE_METADATA_FORMAT/@name/string(), ':-:',  $x//SOURCE_METADATA_FORMAT/@layout/string(), ':-:', $x//SOURCE_METADATA_FORMAT/@interpretation/string(), "
					+ "':-:', $x//BASE_QUERY, ':-:',  $x//TRANSFORMATION_RULE, ':-:', $x/@exportable/string() )";
			Iterable<MDFInfo> mdFormats = this.queryExecutor.query(MDFInfo.class, query, ":-:");
			return Lists.newArrayList(mdFormats);
		} else return getMetadataFormatInfo();
	}

	public MDFInfo getMetadataFormatInfo(final String mdPrefix) {
		final String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION//METADATAFORMAT "
				+ "where $x/@metadataPrefix/string()='"
				+ mdPrefix
				+ "' "
				+ "return concat($x/@metadataPrefix/string(), ':-:', $x//SCHEMA , ':-:', $x//NAMESPACE,  "
				+ "':-:', $x//SOURCE_METADATA_FORMAT/@name/string(), ':-:',  $x//SOURCE_METADATA_FORMAT/@layout/string(), ':-:', $x//SOURCE_METADATA_FORMAT/@interpretation/string(), "
				+ "':-:', $x//BASE_QUERY,':-:', $x//TRANSFORMATION_RULE, ':-:', $x/@exportable/string() )";
		Iterable<MDFInfo> mdFormats = this.queryExecutor.query(MDFInfo.class, query, ":-:");
		Iterator<MDFInfo> iterator = mdFormats.iterator();
		if (iterator.hasNext()) return iterator.next();
		else return null;
	}

	public Multimap<String, String> getIndices(final String format, final String interpretation, final String layout) throws ISLookUpException {
		Multimap<String, String> indices = ArrayListMultimap.create();
		final String query = "for $x in collection('/db/DRIVER/OAIPublisherConfigurationDSResources/OAIPublisherConfigurationDSResourceType')//CONFIGURATION//INDICES/INDEX "
				+ "return concat($x/@name, ':-:', string-join($x/SOURCE[./@name/string()='"
				+ format
				+ "' and ./@interpretation/string()='"
				+ interpretation
				+ "' and ./@layout/string()='" + layout + "']/@path/string(), ':-:'))";
		List<String> res = this.queryExecutor.getLookupLocator().getService().quickSearchProfile(query);
		for (String index : res) {
			String[] splitted = index.split(":-:");
			String indexName = splitted[0];
			for (int i = 1; i < splitted.length; i++) {
				indices.put(indexName, splitted[i]);
			}
		}
		return indices;
	}

	public List<String> getIndexNames() throws ISLookUpException {
		String query = "//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'OAIPublisherConfigurationDSResourceType']//CONFIGURATION//INDICES/INDEX/@name/string()";
		return this.queryExecutor.getLookupLocator().getService().quickSearchProfile(query);
	}

	public SplittedQueryExecutor getQueryExecutor() {
		return queryExecutor;
	}

	public void setQueryExecutor(final SplittedQueryExecutor queryExecutor) {
		this.queryExecutor = queryExecutor;
	}

	public String getIdScheme() {
		return idScheme;
	}

	public void setIdScheme(final String idScheme) {
		this.idScheme = idScheme;
	}

	public String getIdNamespace() {
		return idNamespace;
	}

	public void setIdNamespace(final String idNamespace) {
		this.idNamespace = idNamespace;
	}
}
