package eu.dnetlib.data.information.oai.publisher.conf;

import javax.annotation.Resource;

import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;

public class PublisherConfigurationWriter {

	@Resource(name = "registryLocator")
	private ServiceLocator<ISRegistryService> registryLocator;

	public boolean updateMetadataFormat(final String mdPrefix, final MDFInfo newInfo) throws ISRegistryException {

		final String xUpdate = "update replace //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='OAIPublisherConfigurationDSResourceType']"
				+ "//CONFIGURATION//METADATAFORMAT[./@metadataPrefix='" + mdPrefix + "'] with <METADATAFORMAT exportable=\"" + newInfo.isEnabled()
				+ "\" metadataPrefix=\"" + newInfo.getPrefix() + "\">" + "<NAMESPACE>" + newInfo.getNamespace() + "</NAMESPACE><SCHEMA>" + newInfo.getSchema()
				+ "</SCHEMA><SOURCE_METADATA_FORMAT interpretation=\"" + newInfo.getSourceFormatInterpretation() + "\" layout=\""
				+ newInfo.getSourceFormatLayout() + "\" name=\"" + newInfo.getSourceFormatName() + "\"/><TRANSFORMATION_RULE>"
				+ newInfo.getTransformationRuleID() + "</TRANSFORMATION_RULE><BASE_QUERY>" + newInfo.getBaseQuery() + "</BASE_QUERY></METADATAFORMAT>";
		return this.registryLocator.getService().executeXUpdate(xUpdate);
	}

	public boolean updateOAISet(final String setSpec, final SetInfo newInfo) throws ISRegistryException {
		final String xUpdate = "update replace //RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='OAIPublisherConfigurationDSResourceType']"
				+ "//CONFIGURATION//OAISET[spec/text()='" + setSpec + "'] with " + "<OAISET enabled=\"" + newInfo.isEnabled() + "\">" + "<spec>"
				+ newInfo.getSetSpec() + "</spec>" + "<name>" + newInfo.getSetName() + "</name>" + "<description>" + newInfo.getSetDescription()
				+ "</description>" + "<query>" + newInfo.getQuery() + "</query></OAISET>";

		return this.registryLocator.getService().executeXUpdate(xUpdate);
	}

	public ServiceLocator<ISRegistryService> getRegistryLocator() {
		return registryLocator;
	}

	public void setRegistryLocator(final ServiceLocator<ISRegistryService> registryLocator) {
		this.registryLocator = registryLocator;
	}

}
