package eu.dnetlib.data.information.oai.publisher.core;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.google.common.collect.Lists;

import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;

public class ResumptionTokenImpl implements ResumptionToken {

	private static final Log log = LogFactory.getLog(ResumptionTokenImpl.class); // NOPMD by marko on 11/24/08 5:02 PM

	/**
	 * Total number of documents.
	 */
	private int nMaxElements;
	/**
	 * Requested metadata prefix.
	 */
	private String metadataPrefix;
	/**
	 * Query to use generate the requested records.
	 */
	private String query;

	/**
	 * Number of already read records.
	 */
	private int nRead;

	/**
	 * objIdentifier of the last read document.
	 */
	private String lastObjIdentifier;

	/**
	 * Requested set. Optional.
	 */
	private String requestedSet = "";

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#serialize()
	 */
	@Override
	public String serialize() {
		String escapedQuery = StringEscapeUtils.escapeXml(query);
		List<String> info = Lists.newArrayList("" + nMaxElements, metadataPrefix, escapedQuery, "" + nRead, lastObjIdentifier, requestedSet);
		try {
			String encoded = URLEncoder.encode(StringUtils.join(info, "|"), "UTF-8");
			return encoded;
		} catch (UnsupportedEncodingException e) {
			throw new OaiPublisherRuntimeException(e);
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#deserialize(java.lang.String)
	 */
	@Override
	public void deserialize(final String token) {
		String decoded;
		try {
			decoded = URLDecoder.decode(token, "UTF-8");
		} catch (UnsupportedEncodingException e) {
			throw new OaiPublisherRuntimeException(e);
		}
		String[] info = StringUtils.split(decoded, "|");
		if (info.length < 5) throw new OaiPublisherRuntimeException("badResumptionToken");
		this.nMaxElements = Integer.parseInt(info[0]);
		this.metadataPrefix = info[1];
		String unescapedQuery = StringEscapeUtils.unescapeXml(info[2]);
		this.query = unescapedQuery;
		this.nRead = Integer.parseInt(info[3]);
		this.lastObjIdentifier = info[4];
		if (info.length == 6) {
			this.requestedSet = info[5];
		}
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#getnMaxElements()
	 */
	@Override
	public int getnMaxElements() {
		return nMaxElements;
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#setnMaxElements(int)
	 */
	@Override
	public void setnMaxElements(final int nMaxElements) {
		this.nMaxElements = nMaxElements;
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#getMetadataPrefix()
	 */
	@Override
	public String getMetadataPrefix() {
		return metadataPrefix;
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#setMetadataPrefix(java.lang.String)
	 */
	@Override
	public void setMetadataPrefix(final String metadataPrefix) {
		this.metadataPrefix = metadataPrefix;
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#getQuery()
	 */
	@Override
	public String getQuery() {
		return query;
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#setQuery(java.lang.String)
	 */
	@Override
	public void setQuery(final String query) {
		this.query = query;
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#getnRead()
	 */
	@Override
	public int getnRead() {
		return nRead;
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#setnRead(int)
	 */
	@Override
	public void setnRead(final int nRead) {
		this.nRead = nRead;
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#getLastObjIdentifier()
	 */
	@Override
	public String getLastObjIdentifier() {
		return lastObjIdentifier;
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#setLastObjIdentifier(java.lang.String)
	 */
	@Override
	public void setLastObjIdentifier(final String lastObjIdentifier) {
		this.lastObjIdentifier = lastObjIdentifier;
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#getRequestedSet()
	 */
	@Override
	public String getRequestedSet() {
		return requestedSet;
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.data.information.oai.publisher.core.ResumptionToken#setRequestedSet(java.lang.String)
	 */
	@Override
	public void setRequestedSet(final String requestedSet) {
		this.requestedSet = requestedSet;
	}

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "ResumptionToken [nMaxElements=" + nMaxElements + ", metadataPrefix=" + metadataPrefix + ", query=" + query + ", nRead=" + nRead
				+ ", lastObjIdentifier=" + lastObjIdentifier + ", requestedSet= " + requestedSet + "]";
	}

}
