package eu.dnetlib.data.information.oai.publisher.conf;


public abstract class AbstractOAIConfigurationReader implements OAIConfigurationReader {

	/**
	 * Used to generate the OAI identifiers compliant to the protocol. See
	 * http://www.openarchives.org/OAI/openarchivesprotocol.html#UniqueIdentifier. See property services.oai.publisher.id.scheme.
	 */
	private String idScheme;
	/**
	 * Used to generate the OAI identifiers compliant to the protocol. See
	 * http://www.openarchives.org/OAI/openarchivesprotocol.html#UniqueIdentifier. See property services.oai.publisher.id.namespace.
	 */
	private String idNamespace;

	@Override
	public String getIdScheme() {
		return idScheme;
	}

	@Override
	public void setIdScheme(final String idScheme) {
		this.idScheme = idScheme;
	}

	@Override
	public String getIdNamespace() {
		return idNamespace;
	}

	@Override
	public void setIdNamespace(final String idNamespace) {
		this.idNamespace = idNamespace;
	}

}
