package eu.dnetlib.data.information.oai.publisher.store.sync;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.data.information.oai.publisher.OaiPublisherException;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.store.MongoPublisherStore;
import eu.dnetlib.data.information.oai.publisher.store.MongoPublisherStoreDAO;

public abstract class OAIStoreContentSynchronizer implements Runnable {

	private static final Log log = LogFactory.getLog(OAIStoreContentSynchronizer.class); // NOPMD by marko on 11/24/08 5:02 PM

	private MDFInfo mdfInfo;
	private MongoPublisherStoreDAO publisherStoreDAO;

	@Override
	public void run() {
		log.info("Synchronizing content for metadata prefix " + mdfInfo.getPrefix());
		log.debug(mdfInfo);
		MongoPublisherStore store = this.publisherStoreDAO.getStoreFor(mdfInfo.getPrefix());
		if (store == null) {
			log.debug("Creating store for metadata format: \n" + mdfInfo);
			try {
				store = this.publisherStoreDAO.createStore(mdfInfo.getSourceFormatName(), mdfInfo.getSourceFormatInterpretation(),
						mdfInfo.getSourceFormatLayout());
				log.debug("Created store with id: " + store.getId());
			} catch (OaiPublisherException e) {
				throw new OaiPublisherRuntimeException(e);
			}
		}
		this.synchronizeContent(store);
		log.info("Content ready for metadata format " + mdfInfo.getPrefix());
	}

	protected abstract void synchronizeContent(final MongoPublisherStore store);

	public OAIStoreContentSynchronizer() {
		super();
	}

	public OAIStoreContentSynchronizer(final MDFInfo mdfInfo, final MongoPublisherStoreDAO publisherStoreDAO) {
		super();
		this.mdfInfo = mdfInfo;
		this.publisherStoreDAO = publisherStoreDAO;
	}

	public MDFInfo getMdfInfo() {
		return mdfInfo;
	}

	public void setMdfInfo(final MDFInfo mdfInfo) {
		this.mdfInfo = mdfInfo;
	}

	public MongoPublisherStoreDAO getPublisherStoreDAO() {
		return publisherStoreDAO;
	}

	public void setPublisherStoreDAO(final MongoPublisherStoreDAO publisherStoreDAO) {
		this.publisherStoreDAO = publisherStoreDAO;
	}

}
