/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.conf.sync;

import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import eu.dnetlib.data.information.oai.publisher.sets.MongoSetCollection;
import eu.dnetlib.data.information.oai.publisher.store.MongoPublisherStore;
import eu.dnetlib.data.information.oai.publisher.store.MongoPublisherStoreDAO;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OAISetCounterHelper {
    private static final Log log = LogFactory.getLog(OAISetCounterHelper.class);
    @Resource
    private MongoPublisherStoreDAO mongoPublisherStoreDAO;
    @Resource
    private MongoSetCollection mongoSetCollection;

    public void updateAllCounts(MDFInfo mdFormat) {
        this.updateTotalCount(mdFormat);
        List<SetInfo> sets = this.mongoSetCollection.getAllSets();
        this.updateCountForSets(sets, mdFormat);
    }

    public void updateConfiguredSetOnly(MDFInfo mdFormat) {
        this.updateTotalCount(mdFormat);
        List<SetInfo> sets = this.mongoSetCollection.getConfiguredSets();
        this.updateCountForSets(sets, mdFormat);
    }

    protected void updateTotalCount(MDFInfo mdFormat) {
        log.info((Object)"Ensuring indices on OAI sets mongo collection . . .");
        this.mongoSetCollection.ensureIndexes();
        String format = mdFormat.getSourceFormatName();
        String layout = mdFormat.getSourceFormatLayout();
        String interpretation = mdFormat.getSourceFormatInterpretation();
        String sourceKey = format + "-" + layout + "-" + interpretation;
        log.info((Object)("Updating count for OAI store " + sourceKey + " via metadata prefix " + mdFormat.getPrefix()));
        log.debug((Object)mdFormat);
        MongoPublisherStore store = this.mongoPublisherStoreDAO.getStoreFor(mdFormat.getPrefix());
        if (store == null) {
            log.info((Object)("Can't count elements for not yet created store (" + mdFormat + ")."));
        } else {
            String baseQuery = mdFormat.getBaseQuery();
            log.info((Object)("Counting total for " + mdFormat.getPrefix() + " with query: " + baseQuery));
            int total = store.count(baseQuery);
            this.mongoSetCollection.updateCounts("ALL", mdFormat.getPrefix(), total);
            log.info((Object)("Counts updated for " + mdFormat.getPrefix()));
        }
    }

    protected void updateCountForSets(List<SetInfo> oaiSets, MDFInfo mdFormat) {
        MongoPublisherStore store = this.mongoPublisherStoreDAO.getStoreFor(mdFormat.getPrefix());
        if (store == null) {
            log.info((Object)("Can't count elements for not yet created store (" + mdFormat + ")."));
        } else {
            String baseQuery = mdFormat.getBaseQuery();
            boolean hasBaseQuery = !StringUtils.isBlank((String)baseQuery);
            for (SetInfo setInfo : oaiSets) {
                String setQuery = setInfo.getQuery();
                if (hasBaseQuery) {
                    setQuery = setQuery + " AND " + baseQuery;
                }
                log.info((Object)("Counting total for " + mdFormat.getPrefix() + "set " + setInfo + " with query: " + setQuery));
                int setCount = store.count(setQuery);
                this.mongoSetCollection.updateCounts(setInfo.getSetSpec(), mdFormat.getPrefix(), setCount);
            }
        }
    }

    public MongoPublisherStoreDAO getMongoPublisherStoreDAO() {
        return this.mongoPublisherStoreDAO;
    }

    public void setMongoPublisherStoreDAO(MongoPublisherStoreDAO mongoPublisherStoreDAO) {
        this.mongoPublisherStoreDAO = mongoPublisherStoreDAO;
    }

    public MongoSetCollection getMongoSetCollection() {
        return this.mongoSetCollection;
    }

    public void setMongoSetCollection(MongoSetCollection mongoSetCollection) {
        this.mongoSetCollection = mongoSetCollection;
    }
}

