/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.conf.sync;

import com.google.common.collect.Lists;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationReader;
import eu.dnetlib.data.information.oai.publisher.conf.sync.OAISetCounterHelper;
import eu.dnetlib.data.information.oai.publisher.conf.sync.OAIStoreAllCounterUpdater;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import eu.dnetlib.data.information.oai.publisher.sets.MongoSetCollection;
import eu.dnetlib.enabling.tools.AbstractSchedulable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SchedulableOAIStoreAllCounters
extends AbstractSchedulable {
    private static final Log log = LogFactory.getLog(SchedulableOAIStoreAllCounters.class);
    @Resource(name="oaiConfigurationExistReader")
    private OAIConfigurationReader configurationReader;
    @Resource
    private MongoSetCollection mongoSetCollection;
    @Resource
    private OAISetCounterHelper oaiSetCounterHelper;
    private int maxThreads = 2;
    private boolean alreadyStarted = false;

    protected void doExecute() {
        if (!this.alreadyStarted) {
            this.alreadyStarted = true;
            log.debug((Object)"*****Dropping and re-creating configuration sets******");
            this.mongoSetCollection.dropConfigurationSets();
            List<SetInfo> oaiConfigSets = this.configurationReader.getSets();
            for (SetInfo setInfo : oaiConfigSets) {
                this.mongoSetCollection.upsertSet(setInfo, true);
            }
            log.info((Object)"Starting threads to update OAI store counters");
            List<MDFInfo> metadataFormats = this.configurationReader.getMetadataFormatInfo();
            ExecutorService executor = Executors.newFixedThreadPool(this.maxThreads);
            ArrayList futures = Lists.newArrayList();
            for (MDFInfo mdf : metadataFormats) {
                futures.add(executor.submit(new OAIStoreAllCounterUpdater(mdf, this.oaiSetCounterHelper)));
            }
            executor.shutdown();
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    throw new OaiPublisherRuntimeException((Throwable)e);
                }
                catch (ExecutionException e) {
                    throw new OaiPublisherRuntimeException((Throwable)e);
                }
            }
            log.info((Object)"OAI store counters updated...");
            this.alreadyStarted = false;
        } else {
            log.info((Object)"The update of counters for all metadata prefix and sets is still ongoing...");
        }
    }

    public OAIConfigurationReader getConfigurationReader() {
        return this.configurationReader;
    }

    public void setConfigurationReader(OAIConfigurationReader configurationReader) {
        this.configurationReader = configurationReader;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public MongoSetCollection getMongoSetCollection() {
        return this.mongoSetCollection;
    }

    public void setMongoSetCollection(MongoSetCollection mongoSetCollection) {
        this.mongoSetCollection = mongoSetCollection;
    }

    public OAISetCounterHelper getOaiSetCounterHelper() {
        return this.oaiSetCounterHelper;
    }

    public void setOaiSetCounterHelper(OAISetCounterHelper oaiSetCounterHelper) {
        this.oaiSetCounterHelper = oaiSetCounterHelper;
    }
}

