/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.wf;

import com.googlecode.sarasvati.Engine;
import com.googlecode.sarasvati.NodeToken;
import eu.dnetlib.data.information.oai.publisher.store.MongoPublisherStore;
import eu.dnetlib.data.information.oai.publisher.store.MongoPublisherStoreDAO;
import eu.dnetlib.enabling.tools.SplittedQueryExecutor;
import eu.dnetlib.workflow.AbstractJobNode;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FindPublisherStoreJob
extends AbstractJobNode {
    private static final Log log = LogFactory.getLog(FindPublisherStoreJob.class);
    private String mdstoreIDAttributeName = "mdId";
    private String pubstoreIDAttributeName = "pubstoreId";
    private String repositoryIDAttributeName = "repositoryId";
    @Resource
    private SplittedQueryExecutor queryExecutor;
    @Resource
    private MongoPublisherStoreDAO publisherStoreDAO;

    public void execute(Engine engine, NodeToken token) {
        try {
            String mdstoreID = token.getFullEnv().getAttribute(this.mdstoreIDAttributeName);
            String repoID = token.getFullEnv().getAttribute(this.repositoryIDAttributeName);
            token.getEnv().setAttribute(this.repositoryIDAttributeName, repoID);
            String xquery = "let $x := //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='" + mdstoreID + "']//CONFIGURATION " + "return concat($x/METADATA_FORMAT/text(), ':=:', $x/METADATA_FORMAT_INTERPRETATION/text(), ':=:', $x/METADATA_FORMAT_LAYOUT/text())";
            String mdfInfo = this.queryExecutor.queryFirst(xquery);
            if (mdfInfo != null) {
                String[] infoSplitted = mdfInfo.split(":=:");
                MongoPublisherStore store = this.publisherStoreDAO.getStore(infoSplitted[0], infoSplitted[1], infoSplitted[2]);
                if (store == null) {
                    log.fatal((Object)("Publisher store for " + infoSplitted[0] + " " + infoSplitted[1] + " " + infoSplitted[2] + " does not exist!"));
                    engine.complete(token, "notFound");
                } else {
                    log.debug((Object)("Found Publisher store for " + infoSplitted[0] + " " + infoSplitted[1] + " " + infoSplitted[2]));
                    token.getEnv().setAttribute(this.pubstoreIDAttributeName, store.getId());
                    engine.complete(token, "found");
                }
            } else {
                token.getEnv().setAttribute("hasFailed", (Object)true);
                token.getEnv().setAttribute("errorMessage", "cannot find metadata format properties for mdstore with id " + mdstoreID);
                engine.complete(token, "failed");
            }
        }
        catch (Exception e) {
            this.failed(engine, token, e);
        }
    }

    public String getMdstoreIDAttributeName() {
        return this.mdstoreIDAttributeName;
    }

    public void setMdstoreIDAttributeName(String mdstoreIDAttributeName) {
        this.mdstoreIDAttributeName = mdstoreIDAttributeName;
    }

    public SplittedQueryExecutor getQueryExecutor() {
        return this.queryExecutor;
    }

    public void setQueryExecutor(SplittedQueryExecutor queryExecutor) {
        this.queryExecutor = queryExecutor;
    }

    public MongoPublisherStoreDAO getPublisherStoreDAO() {
        return this.publisherStoreDAO;
    }

    public void setPublisherStoreDAO(MongoPublisherStoreDAO publisherStoreDAO) {
        this.publisherStoreDAO = publisherStoreDAO;
    }

    public String getPubstoreIDAttributeName() {
        return this.pubstoreIDAttributeName;
    }

    public void setPubstoreIDAttributeName(String pubstoreIDAttributeName) {
        this.pubstoreIDAttributeName = pubstoreIDAttributeName;
    }

    public String getRepositoryIDAttributeName() {
        return this.repositoryIDAttributeName;
    }

    public void setRepositoryIDAttributeName(String repositoryIDAttributeName) {
        this.repositoryIDAttributeName = repositoryIDAttributeName;
    }
}

