package eu.dnetlib.data.information.oai.publisher.store.sync;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import com.google.common.collect.Lists;

import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationReader;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.enabling.tools.AbstractSchedulable;

public class SchedulableContentSynchronizer extends AbstractSchedulable {

	private static final Log log = LogFactory.getLog(SchedulableContentSynchronizer.class); // NOPMD by marko on 11/24/08 5:02 PM
	/**
	 * OAI Publisher configuration.
	 */
	@Resource(name = "oaiConfigurationExistReader")
	private OAIConfigurationReader configuration;

	private OAIStoreContentSynchronizerFactory contentSyncFactory;

	private int maxInitThreads = 2;

	@Override
	protected void doExecute() {
		log.info("Synchronizing OAI stores with content using synchronizer from factory: " + contentSyncFactory.getClass().getCanonicalName());
		new Thread() {

			@Override
			public void run() {
				checkStores();
			}

		}.start();
	}

	protected void checkStores() {
		final ExecutorService executor = Executors.newFixedThreadPool(maxInitThreads);
		List<MDFInfo> metadataFormats = this.configuration.getMetadataFormatInfo();
		List<Future<?>> futures = Lists.newArrayList();
		for (MDFInfo mdf : metadataFormats) {
			futures.add(executor.submit(contentSyncFactory.create(mdf)));
		}
		executor.shutdown();
		for (Future<?> future : futures) {
			try {
				future.get();
			} catch (InterruptedException e) {
				throw new OaiPublisherRuntimeException(e);
			} catch (ExecutionException e) {
				throw new OaiPublisherRuntimeException(e);
			}
		}
	}

	public int getMaxInitThreads() {
		return maxInitThreads;
	}

	public void setMaxInitThreads(final int maxInitThreads) {
		this.maxInitThreads = maxInitThreads;
	}

	public OAIConfigurationReader getConfiguration() {
		return configuration;
	}

	public void setConfiguration(final OAIConfigurationReader configuration) {
		this.configuration = configuration;
	}

	public OAIStoreContentSynchronizerFactory getContentSyncFactory() {
		return contentSyncFactory;
	}

	@Required
	public void setContentSyncFactory(final OAIStoreContentSynchronizerFactory contentSyncFactory) {
		this.contentSyncFactory = contentSyncFactory;
	}

}
