package eu.dnetlib.data.information.oai.publisher.conf.sync;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import eu.dnetlib.data.information.oai.publisher.sets.MongoSetCollection;
import eu.dnetlib.data.information.oai.publisher.store.MongoPublisherStore;
import eu.dnetlib.data.information.oai.publisher.store.MongoPublisherStoreDAO;

public class OAISetCounterHelper {

	private static final Log log = LogFactory.getLog(OAISetCounterHelper.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Resource
	private MongoPublisherStoreDAO mongoPublisherStoreDAO;
	@Resource
	private MongoSetCollection mongoSetCollection;

	public void updateAllCounts(final MDFInfo mdFormat) {
		updateTotalCount(mdFormat);
		List<SetInfo> sets = mongoSetCollection.getAllSets();
		this.updateCountForSets(sets, mdFormat);
	}

	public void updateConfiguredSetOnly(final MDFInfo mdFormat) {
		updateTotalCount(mdFormat);
		List<SetInfo> sets = mongoSetCollection.getConfiguredSets();
		this.updateCountForSets(sets, mdFormat);
	}

	protected void updateTotalCount(final MDFInfo mdFormat) {
		log.info("Ensuring indices on OAI sets mongo collection . . .");
		this.mongoSetCollection.ensureIndexes();
		String format = mdFormat.getSourceFormatName();
		String layout = mdFormat.getSourceFormatLayout();
		String interpretation = mdFormat.getSourceFormatInterpretation();
		String sourceKey = format + "-" + layout + "-" + interpretation;
		log.info("Updating count for OAI store " + sourceKey + " via metadata prefix " + mdFormat.getPrefix());
		log.debug(mdFormat);
		MongoPublisherStore store = this.mongoPublisherStoreDAO.getStoreFor(mdFormat.getPrefix());
		if (store == null) {
			log.info("Can't count elements for not yet created store (" + mdFormat + ").");
		} else {
			String baseQuery = mdFormat.getBaseQuery();
			log.info("Counting total for " + mdFormat.getPrefix() + " with query: " + baseQuery);
			int total = store.count(baseQuery);
			mongoSetCollection.updateCounts("ALL", mdFormat.getPrefix(), total);
			log.info("Counts updated for " + mdFormat.getPrefix());
		}
	}

	protected void updateCountForSets(final List<SetInfo> oaiSets, final MDFInfo mdFormat) {
		MongoPublisherStore store = this.mongoPublisherStoreDAO.getStoreFor(mdFormat.getPrefix());
		if (store == null) {
			log.info("Can't count elements for not yet created store (" + mdFormat + ").");
		} else {
			String baseQuery = mdFormat.getBaseQuery();
			boolean hasBaseQuery = !StringUtils.isBlank(baseQuery);
			for (SetInfo setInfo : oaiSets) {
				String setQuery = setInfo.getQuery();
				if (hasBaseQuery) {
					setQuery += " AND " + baseQuery;
				}
				log.info("Counting total for " + mdFormat.getPrefix() + "set " + setInfo + " with query: " + setQuery);
				int setCount = store.count(setQuery);
				mongoSetCollection.updateCounts(setInfo.getSetSpec(), mdFormat.getPrefix(), setCount);
			}
		}
	}

	public MongoPublisherStoreDAO getMongoPublisherStoreDAO() {
		return mongoPublisherStoreDAO;
	}

	public void setMongoPublisherStoreDAO(final MongoPublisherStoreDAO mongoPublisherStoreDAO) {
		this.mongoPublisherStoreDAO = mongoPublisherStoreDAO;
	}

	public MongoSetCollection getMongoSetCollection() {
		return mongoSetCollection;
	}

	public void setMongoSetCollection(final MongoSetCollection mongoSetCollection) {
		this.mongoSetCollection = mongoSetCollection;
	}
}
