/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.store.parser;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import eu.dnetlib.data.information.oai.publisher.store.PublisherField;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class PublisherRecordParser {
    private static final Log log = LogFactory.getLog(PublisherRecordParser.class);
    private List<PublisherField> storeIndices;
    private final SAXReader saxReader = new SAXReader();

    public Multimap<String, String> parseRecord(String record) {
        ArrayListMultimap recordProps = ArrayListMultimap.create();
        try {
            Document doc = this.saxReader.read((Reader)new StringReader(record));
            for (PublisherField field : this.storeIndices) {
                for (Map.Entry indexEntry : field.getSources().entries()) {
                    List xPathResult = doc.selectNodes((String)indexEntry.getValue());
                    if (xPathResult == null || xPathResult.isEmpty()) continue;
                    if (this.containsStrings(xPathResult)) {
                        recordProps.putAll((Object)field.getFieldName(), (Iterable)xPathResult);
                        continue;
                    }
                    if (!this.containsNodes(xPathResult)) continue;
                    recordProps.putAll((Object)field.getFieldName(), Iterables.transform((Iterable)xPathResult, (Function)new Function<Object, String>(){

                        public String apply(Object obj) {
                            if (obj == null) {
                                return "";
                            }
                            Node node = (Node)obj;
                            return node.getText();
                        }
                    }));
                }
            }
        }
        catch (DocumentException e) {
            log.fatal((Object)"Can't parse record");
            recordProps = null;
        }
        return recordProps;
    }

    private boolean containsStrings(List objects) {
        Object first = objects.get(0);
        return first instanceof String;
    }

    private boolean containsNodes(List objects) {
        Object first = objects.get(0);
        return first instanceof Node;
    }

    public List<PublisherField> getStoreIndices() {
        return this.storeIndices;
    }

    public void setStoreIndices(List<PublisherField> storeIndices) {
        this.storeIndices = storeIndices;
    }

    public SAXReader getSaxReader() {
        return this.saxReader;
    }

    public PublisherRecordParser(List<PublisherField> storeIndices) {
        this.storeIndices = storeIndices;
    }

    public PublisherRecordParser() {
    }
}

