/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.conf;

import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.miscutils.functional.IdentityFunction;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import eu.dnetlib.miscutils.functional.xml.ApplyXslt;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ISLookUpClient {
    @Resource(name="lookupLocator")
    private ServiceLocator<ISLookUpService> lookupLocator;
    private static final Log log = LogFactory.getLog(ISLookUpClient.class);

    public UnaryFunction<String, String> getUnaryFunctionFromTDSRule(String tdsRuleId) {
        String queryCodeRule = "//RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value='" + tdsRuleId + "']/BODY/CONFIGURATION/SCRIPT/CODE/*[local-name()='stylesheet']";
        String xsltCode = null;
        try {
            xsltCode = ((ISLookUpService)this.lookupLocator.getService()).getResourceProfileByQuery(queryCodeRule);
        }
        catch (ISLookUpDocumentNotFoundException e) {
            log.fatal((Object)("Unexisting TDSRule profile with identifier " + tdsRuleId));
            throw new OaiPublisherRuntimeException((Throwable)e);
        }
        catch (ISLookUpException e) {
            throw new OaiPublisherRuntimeException((Throwable)e);
        }
        if (StringUtils.isBlank((String)xsltCode)) {
            log.warn((Object)("Unexpected blank stylesheet in TDSRule profile with id: " + tdsRuleId + ". Returning identity function."));
            return new IdentityFunction();
        }
        return new ApplyXslt(xsltCode);
    }

    public ServiceLocator<ISLookUpService> getLookupLocator() {
        return this.lookupLocator;
    }

    public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
        this.lookupLocator = lookupLocator;
    }
}

