/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.conf;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import eu.dnetlib.data.information.oai.publisher.store.PublisherField;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class OAIConfiguration {
    private Map<String, SetInfo> setsMap;
    private Map<String, MDFInfo> mdFormatsMap;
    private List<PublisherField> fields;
    private List<String> fieldNames;
    private Set<MDFInfo> sourcesMDF = Sets.newHashSet();

    public Collection<PublisherField> getFieldsFor(final String format, final String layout, final String interpretation) {
        return Collections2.filter(this.getFields(), (Predicate)new Predicate<PublisherField>(){

            public boolean apply(PublisherField theField) {
                if (theField.getSources() == null) {
                    return false;
                }
                return theField.getSources().containsKey((Object)StringUtils.join((Object[])new String[]{format, layout, interpretation}, (String)"-"));
            }
        });
    }

    public Map<String, SetInfo> getSetsMap() {
        return this.setsMap;
    }

    public void setSetsMap(Map<String, SetInfo> setsMap) {
        this.setsMap = setsMap;
    }

    public Map<String, MDFInfo> getMdFormatsMap() {
        return this.mdFormatsMap;
    }

    public void setMdFormatsMap(Map<String, MDFInfo> mdFormatsMap) {
        this.mdFormatsMap = mdFormatsMap;
    }

    public List<PublisherField> getFields() {
        return this.fields;
    }

    public void setFields(List<PublisherField> fields) {
        this.fields = fields;
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public void setFieldNames(List<String> fieldNames) {
        this.fieldNames = fieldNames;
    }

    public Set<MDFInfo> getSourcesMDF() {
        return this.sourcesMDF;
    }

    public void setSourcesMDF(Set<MDFInfo> sourcesMDF) {
        this.sourcesMDF = sourcesMDF;
    }
}

