/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.information.oai.publisher.core;

import com.google.common.collect.Lists;
import eu.dnetlib.data.information.oai.publisher.BadResumptionTokenException;
import eu.dnetlib.data.information.oai.publisher.CannotDisseminateFormatException;
import eu.dnetlib.data.information.oai.publisher.NoRecordsMatchException;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherException;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.conf.ISLookUpClient;
import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationReader;
import eu.dnetlib.data.information.oai.publisher.core.AbstractOAICore;
import eu.dnetlib.data.information.oai.publisher.info.ListDocumentsInfo;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.information.oai.publisher.info.RecordInfo;
import eu.dnetlib.data.information.oai.publisher.info.ResumptionToken;
import eu.dnetlib.data.information.oai.publisher.info.ResumptionTokenImpl;
import eu.dnetlib.data.information.oai.publisher.info.SetInfo;
import eu.dnetlib.data.oai.store.Cursor;
import eu.dnetlib.data.oai.store.PublisherStore;
import eu.dnetlib.data.oai.store.PublisherStoreDAO;
import eu.dnetlib.data.oai.store.sets.MongoSetCollection;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DNetOAICore
extends AbstractOAICore {
    private static final Log log = LogFactory.getLog(DNetOAICore.class);
    @Resource
    private ISLookUpClient lookupClient;
    @Resource(name="oaiConfigurationExistReader")
    private OAIConfigurationReader configurationReader;
    @Resource
    private MongoSetCollection setCollection;
    @Resource
    private PublisherStoreDAO<PublisherStore<Cursor>, Cursor> publisherStoreDAO;
    private String defaultDate = "2008-01-01T12:00:00Z";
    private int pageSize = 100;

    protected RecordInfo getRecordById(MDFInfo mdf, String id) throws OaiPublisherException {
        PublisherStore store = this.publisherStoreDAO.getStoreFor(mdf.getPrefix());
        if (store == null) {
            throw new OaiPublisherRuntimeException("Missing store for metadata prefix " + mdf.getPrefix() + ". Please check OAI publisher configuration.");
        }
        RecordInfo record = null;
        if (StringUtils.isBlank((String)mdf.getTransformationRuleID())) {
            record = store.getRecord(id);
        } else {
            UnaryFunction function = this.lookupClient.getUnaryFunctionFromTDSRule(mdf.getTransformationRuleID());
            record = store.getRecord(id, function);
        }
        if (record != null) {
            record.setPrefix(mdf.getPrefix());
        }
        return record;
    }

    public List<SetInfo> listSets() {
        return this.setCollection.getAllSets();
    }

    public List<MDFInfo> listMetadataFormats() {
        return this.configurationReader.getMetadataFormatInfo(true);
    }

    protected ListDocumentsInfo getDocuments(boolean onlyIdentifiers, String set, String metadataPrefix, String from, String until) throws OaiPublisherException {
        MDFInfo mdf = this.obtainMDFInfo(metadataPrefix);
        boolean hasDateRange = StringUtils.isNotBlank((String)from) || StringUtils.isNotBlank((String)until);
        String query = this.generateQuery(mdf, set, from, until, hasDateRange);
        int total = this.countTotal(hasDateRange, query, set, mdf);
        log.debug((Object)("Total number of records: " + total));
        Cursor results = this.getCursor(query, onlyIdentifiers, mdf);
        ListDocumentsInfo res = this.prepareListDocumentsInfo(results, mdf, query, set, 0, total, hasDateRange);
        log.debug((Object)("Delivering " + res.getDocs().size() + " in a page"));
        return res;
    }

    protected ListDocumentsInfo getDocuments(boolean onlyIdentifiers, String resumptionToken) throws OaiPublisherException {
        ResumptionTokenImpl resToken = new ResumptionTokenImpl();
        resToken.deserialize(resumptionToken);
        log.info((Object)resToken.toString());
        MDFInfo mdf = this.obtainMDFInfo(resToken.getMetadataPrefix());
        String lastID = resToken.getLastObjIdentifier();
        String query = resToken.getQuery();
        String newQuery = query + " AND _id > \"" + lastID + "\"";
        log.debug((Object)("NEW QUERY BECAUSE of resumptionToken: " + newQuery));
        int total = this.countTotal(resToken.hasDateRange(), query, resToken.getRequestedSet(), mdf);
        Cursor results = this.getCursor(newQuery, onlyIdentifiers, mdf);
        int oldCount = resToken.getnMaxElements();
        if (oldCount != total) {
            throw new BadResumptionTokenException(resumptionToken);
        }
        ListDocumentsInfo res = this.prepareListDocumentsInfo(results, mdf, query, resToken.getRequestedSet(), resToken.getnRead(), resToken.getnMaxElements(), resToken.hasDateRange());
        res.setCursor(resToken.getnRead());
        return res;
    }

    protected MDFInfo obtainMDFInfo(String metadataPrefix) throws OaiPublisherException {
        MDFInfo mdf = this.configurationReader.getMetadataFormatInfo(metadataPrefix);
        if (mdf == null) {
            throw new CannotDisseminateFormatException("Invalid metadataPrefix " + metadataPrefix);
        }
        return mdf;
    }

    protected ListDocumentsInfo prepareListDocumentsInfo(Cursor results, MDFInfo mdf, String query, String requestedSet, int read, int totalNumber, boolean hasDateRange) throws OaiPublisherException {
        ListDocumentsInfo documentList = new ListDocumentsInfo();
        documentList.setnMaxElements(totalNumber);
        documentList.setMetadataPrefix(mdf.getPrefix());
        documentList.setCursor(0);
        List<RecordInfo> theRecords = this.generateOAIRecords(mdf, requestedSet, results);
        if (documentList.getnMaxElements() <= 0) {
            throw new NoRecordsMatchException("No records match the requested criteria");
        }
        documentList.setDocs(theRecords);
        if (theRecords == null || theRecords.isEmpty()) {
            throw new NoRecordsMatchException("noRecordsMatch: 'documents' is null or empty");
        }
        if (documentList.getnMaxElements() > read + theRecords.size()) {
            String lastID = theRecords.get(theRecords.size() - 1).getInternalId();
            ResumptionTokenImpl nextToken = new ResumptionTokenImpl();
            nextToken.setDateRange(hasDateRange);
            nextToken.setLastObjIdentifier(lastID);
            nextToken.setMetadataPrefix(mdf.getPrefix());
            nextToken.setnMaxElements(totalNumber);
            nextToken.setnRead(read + theRecords.size());
            nextToken.setQuery(query);
            nextToken.setRequestedSet(requestedSet);
            documentList.setResumptionToken((ResumptionToken)nextToken);
        }
        return documentList;
    }

    protected Cursor getCursor(String query, boolean onlyIdentifiers, MDFInfo mdfInfo) {
        PublisherStore store = this.publisherStoreDAO.getStore(mdfInfo.getSourceFormatName(), mdfInfo.getSourceFormatInterpretation(), mdfInfo.getSourceFormatLayout());
        if (store == null) {
            throw new OaiPublisherRuntimeException("Missing store for metadata prefix " + mdfInfo.getPrefix() + ". Please check OAI publisher configuration.");
        }
        Cursor results = null;
        if (StringUtils.isBlank((String)mdfInfo.getTransformationRuleID())) {
            results = store.getRecords(query, !onlyIdentifiers, this.pageSize);
        } else {
            UnaryFunction function = this.lookupClient.getUnaryFunctionFromTDSRule(mdfInfo.getTransformationRuleID());
            results = store.getRecords(query, function, !onlyIdentifiers, this.pageSize);
        }
        return results;
    }

    protected List<RecordInfo> generateOAIRecords(MDFInfo mdf, String requestedSet, Cursor cursor) {
        ArrayList documents = Lists.newArrayList();
        for (RecordInfo current : cursor) {
            current.addSetspec(requestedSet);
            current.setPrefix(mdf.getPrefix());
            documents.add(current);
        }
        return documents;
    }

    protected String generateQuery(MDFInfo mdf, String set, String from, String until, boolean hasDateRange) {
        String datestampIndexName = "datestamp";
        String query = mdf.getBaseQuery();
        if (!StringUtils.isBlank((String)set)) {
            if (!StringUtils.isBlank((String)query)) {
                query = query + " AND ";
            }
            query = query + this.setCollection.getSetQuery(set);
        }
        if (hasDateRange) {
            if (query.length() > 0) {
                query = query + " AND ";
            }
            if (from != null && until != null) {
                query = query + datestampIndexName + " >= " + from + " AND " + datestampIndexName + " <= " + until;
            } else if (from != null) {
                query = query + datestampIndexName + " >= " + from;
            } else if (until != null) {
                query = query + datestampIndexName + " <= " + until;
            }
        }
        log.info((Object)("QUERY GENERATED: \n" + query));
        return query;
    }

    private int countTotal(boolean hasDateRange, String query, String set, MDFInfo mdFormat) {
        PublisherStore store = this.publisherStoreDAO.getStore(mdFormat.getSourceFormatName(), mdFormat.getSourceFormatInterpretation(), mdFormat.getSourceFormatLayout());
        int total = 0;
        if (hasDateRange) {
            total = store.count(query);
        } else {
            log.fatal((Object)("SET::: " + set));
            total = StringUtils.isNotBlank((String)set) ? this.setCollection.count(set, mdFormat.getPrefix()) : this.setCollection.count("ALL", mdFormat.getPrefix());
        }
        return total;
    }

    public void setLookupClient(ISLookUpClient lookupClient) {
        this.lookupClient = lookupClient;
    }

    public String getDefaultDate() {
        return this.defaultDate;
    }

    public void setDefaultDate(String defaultDate) {
        this.defaultDate = defaultDate;
    }

    public PublisherStoreDAO<PublisherStore<Cursor>, Cursor> getPublisherStoreDAO() {
        return this.publisherStoreDAO;
    }

    public void setPublisherStoreDAO(PublisherStoreDAO<PublisherStore<Cursor>, Cursor> publisherStoreDAO) {
        this.publisherStoreDAO = publisherStoreDAO;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public ISLookUpClient getLookupClient() {
        return this.lookupClient;
    }

    public MongoSetCollection getSetCollection() {
        return this.setCollection;
    }

    public void setSetCollection(MongoSetCollection setCollection) {
        this.setCollection = setCollection;
    }

    public OAIConfigurationReader getConfigurationReader() {
        return this.configurationReader;
    }

    public void setConfigurationReader(OAIConfigurationReader configurationReader) {
        this.configurationReader = configurationReader;
    }
}

