package eu.dnetlib.enabling.database.inspector;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;

import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;

import org.apache.commons.io.IOUtils;

public abstract class AbstractController {
	
	public static final String CTYPE_CSS = "text/css";
	public static final String CTYPE_JS = "text/javascript";
	public static final String CTYPE_XML = "text/xml";
	public static final String CTYPE_TEXT = "text/plain";
	public static final String CTYPE_HTML = "text/html";
	
	public void sendFile(final ServletResponse response, final InputStream input, final String ctype) throws IOException {
		response.setContentType(ctype);
		ServletOutputStream out = response.getOutputStream();
		IOUtils.copy(input, out);
		out.flush();
		out.close();
	}

	public void sendFile(final ServletResponse response, final Reader input, final String ctype) throws IOException {
		response.setContentType(ctype);
		ServletOutputStream out = response.getOutputStream();
		IOUtils.copy(input, out);
		out.flush();
		out.close();
	}
	
	public void sendFile(final ServletResponse response, final String content, final String ctype) throws IOException {
		sendFile(response, new StringReader(content), ctype);
	}

}
