/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.hcm.sn;

import eu.dnetlib.enabling.actions.SubscriptionAction;
import eu.dnetlib.enabling.hcm.sn.HCMSubscriber;
import eu.dnetlib.enabling.is.sn.rmi.ISSNException;
import eu.dnetlib.enabling.is.sn.rmi.ISSNService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.soap.EndpointReferenceBuilder;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.xml.ws.Endpoint;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class HCMSubscriberImpl
implements HCMSubscriber {
    private static final Log log = LogFactory.getLog(HCMSubscriberImpl.class);
    private Endpoint endpoint;
    private ServiceLocator<ISSNService> snLocator;
    @Resource(name="jaxwsEndpointReferenceBuilder")
    private EndpointReferenceBuilder<Endpoint> eprBuilder;
    private List<SubscriptionAction> actions;

    @PostConstruct
    public void printList() {
        log.info(this.getActions());
    }

    @Override
    public void subscribeAll() throws ISSNException {
        W3CEndpointReference endpointReference = this.eprBuilder.getEndpointReference((Object)this.getEndpoint());
        for (SubscriptionAction action : this.getActions()) {
            log.info((Object)("dynamically subscribing to " + action.getTopicExpression()));
            ((ISSNService)this.snLocator.getService()).subscribe(endpointReference, action.getTopicExpression(), 0);
        }
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEprBuilder(EndpointReferenceBuilder<Endpoint> eprBuilder) {
        this.eprBuilder = eprBuilder;
    }

    public EndpointReferenceBuilder<Endpoint> getEprBuilder() {
        return this.eprBuilder;
    }

    public ServiceLocator<ISSNService> getSnLocator() {
        return this.snLocator;
    }

    public void setSnLocator(ServiceLocator<ISSNService> snLocator) {
        this.snLocator = snLocator;
    }

    public List<SubscriptionAction> getActions() {
        return this.actions;
    }

    @Required
    public void setActions(List<SubscriptionAction> actions) {
        this.actions = actions;
    }
}

