/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.inspector;

import com.google.common.collect.Lists;
import eu.dnetlib.enabling.tools.ResourceIdentifierResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Required;

public class ResourceLinkTool {
    private static String REGEX = "([a-zA-Z0-9]+\\-)+[a-zA-Z0-9]+_[a-zA-Z0-9]+";
    private String serviceBaseUrl;
    private ResourceIdentifierResolver resolver;

    public String linkfyToHtml(String profile) {
        String tmp = new String(profile);
        for (String id : this.enumerateIds(profile)) {
            tmp = tmp.replaceAll(id, this.toLink(id));
        }
        return tmp;
    }

    protected String toLink(String id) {
        return "<a href=\"" + this.serviceBaseUrl + "/inspector/index.do/db/DRIVER/" + this.getResolver().getCollectionName(id) + "/" + this.getResolver().getFileName(id) + "/show\">" + id + "</a>";
    }

    private List<String> enumerateIds(String profile) {
        ArrayList ids = Lists.newArrayList();
        String tmp = new String(profile);
        Pattern p = Pattern.compile(REGEX);
        Matcher m = p.matcher(tmp);
        while (m.find()) {
            ids.add(m.group());
        }
        return ids;
    }

    @Required
    public void setResolver(ResourceIdentifierResolver resolver) {
        this.resolver = resolver;
    }

    public ResourceIdentifierResolver getResolver() {
        return this.resolver;
    }

    @Required
    public void setServiceBaseUrl(String serviceBaseUrl) {
        this.serviceBaseUrl = serviceBaseUrl;
    }

    public String getServiceBaseUrl() {
        return this.serviceBaseUrl;
    }
}

